/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.lib;

import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.Device;
import org.eclipse.scada.configuration.infrastructure.lib.DriverValidator;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;

public abstract class DeviceValidator<T extends AbstractFactoryDriver, D extends Device>
implements DriverValidator<T> {
    private final Class<D> deviceClass;

    public DeviceValidator(Class<D> deviceClass) {
        this.deviceClass = deviceClass;
    }

    @Override
    public void validate(ValidationContext ctx, T driver) {
        for (Device device : driver.getDevices()) {
            if (!this.deviceClass.isAssignableFrom(device.getClass())) continue;
            this.validateDevice((Device)this.deviceClass.cast(device), ctx);
        }
    }

    protected abstract void validateDevice(D var1, ValidationContext var2);
}

