/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ide.vi.preview.editor;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.scada.ide.vi.preview.editor.Activator;
import org.eclipse.scada.ui.utils.status.StatusHelper;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractModelEditor
extends EditorPart
implements IEditingDomainProvider {
    private static final Logger logger = LoggerFactory.getLogger(AbstractModelEditor.class);
    private final IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected List<Resource> changedResources;
                    protected List<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.resourceSet = AbstractModelEditor.this.getEditingDomain().getResourceSet();
                        this.changedResources = new LinkedList<Resource>();
                        this.removedResources = new LinkedList<Resource>();
                    }

                    public boolean visit(IResourceDelta delta) {
                        if (delta.getResource().getType() != 1) {
                            return true;
                        }
                        if (delta.getFlags() == 131072) {
                            return false;
                        }
                        Resource resource = this.resourceSet.getResource(URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true), false);
                        if (resource == null) {
                            return false;
                        }
                        switch (delta.getKind()) {
                            case 2: {
                                this.removedResources.add(resource);
                                break;
                            }
                            case 4: {
                                this.changedResources.add(resource);
                            }
                        }
                        return false;
                    }

                    public boolean isChanged() {
                        return !this.removedResources.isEmpty() || !this.changedResources.isEmpty();
                    }
                }
                final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (visitor.isChanged()) {
                    AbstractModelEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){
                        {
                        }

                        @Override
                        public void run() {
                            AbstractModelEditor.this.handleInputChanged(visitor.changedResources, visitor.removedResources);
                        }
                    });
                }
            }
            catch (CoreException exception) {
                Activator.getDefault().getLog().log(exception.getStatus());
            }
        }
    };
    private IFileEditorInput fileInput;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(input);
        this.setPartName(input.getName());
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        super.dispose();
    }

    protected void setInputWithNotify(IEditorInput input) {
        super.setInputWithNotify(input);
        this.fileInput = (IFileEditorInput)input;
        IFile file = this.fileInput.getFile();
        try {
            URI uri = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.getEditingDomain().getResourceSet().createResource(uri);
            resource.load(null);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load input", e);
        }
    }

    public boolean isDirty() {
        return ((BasicCommandStack)this.getEditingDomain().getCommandStack()).isSaveNeeded();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected Resource getEditorResource() {
        if (this.fileInput == null) {
            return null;
        }
        IFile file = this.fileInput.getFile();
        if (file == null) {
            return null;
        }
        Resource resource = this.getEditingDomain().getResourceSet().getResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true), false);
        if (resource == null) {
            return null;
        }
        return resource;
    }

    protected EObject getModelObject() {
        Resource resource = this.getEditorResource();
        if (resource == null || resource.getContents().isEmpty()) {
            return null;
        }
        return (EObject)resource.getContents().get(0);
    }

    protected void handleInputChanged(List<Resource> changedResources, List<Resource> removedResources) {
        for (Resource resource : removedResources) {
            logger.debug("Resource removed: {}", (Object)resource);
            if (!resource.isLoaded()) continue;
            logger.debug("Unloading: {}", (Object)resource);
            resource.unload();
        }
        for (Resource resource : changedResources) {
            logger.debug("Resource changed: {}", (Object)resource);
            if (!resource.isLoaded()) continue;
            logger.debug("Reloading: {}", (Object)resource);
            resource.unload();
            try {
                resource.load(null);
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log(StatusHelper.convertStatus((String)"org.eclipse.scada.ide.vi.preview.editor", (Throwable)e));
            }
        }
    }
}

