/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.ide.vi.preview.editor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.scada.ide.vi.preview.editor.AbstractModelEditor;
import org.eclipse.scada.ide.vi.preview.editor.Activator;
import org.eclipse.scada.vi.model.Symbol;
import org.eclipse.scada.vi.ui.draw2d.FactoryContext;
import org.eclipse.scada.vi.ui.draw2d.VisualInterfaceViewer;
import org.eclipse.scada.vi.ui.draw2d.loader.StaticSymbolLoader;
import org.eclipse.scada.vi.ui.draw2d.loader.SymbolLoader;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.statushandlers.StatusManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewEditorImpl
extends AbstractModelEditor {
    public static final String EDITOR_ID = "org.eclipse.scada.ide.vi.preview.editor";
    private static final Logger logger = LoggerFactory.getLogger(PreviewEditorImpl.class);
    private final ComposedAdapterFactory adapterFactory;
    private final AdapterFactoryEditingDomain editingDomain;
    private Composite symbolArea;
    private VisualInterfaceViewer viewer;
    private final FactoryContext factoryContext;
    private final IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            PreviewEditorImpl.this.handleResourceChanged(event);
        }
    };
    private final Set<URI> loadedUris = new HashSet<URI>();
    private boolean needReload;

    public PreviewEditorImpl() {
        this.adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)commandStack, new HashMap());
        this.factoryContext = new FactoryContext(){

            public void loadedResource(URI uri) {
                PreviewEditorImpl.this.handleLoadedResource(uri);
            }
        };
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    protected void handleResourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    return PreviewEditorImpl.this.handleResource(delta);
                }
            });
        }
        catch (CoreException e) {
            StatusManager.getManager().handle(e.getStatus());
        }
        if (this.needReload) {
            this.needReload = false;
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PreviewEditorImpl.this.reload();
                }
            });
        }
    }

    protected boolean handleResource(IResourceDelta delta) {
        if (delta.getResource().getType() != 1) {
            return true;
        }
        if (delta.getFlags() == 131072) {
            return false;
        }
        URI uri = URI.createPlatformResourceURI((String)delta.getFullPath().toString(), (boolean)true);
        if (!this.loadedUris.contains(uri)) {
            return true;
        }
        this.fireResourceChange();
        return true;
    }

    private void fireResourceChange() {
        this.needReload = true;
    }

    protected void handleLoadedResource(URI uri) {
        this.loadedUris.add(uri);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.adapterFactory.dispose();
        super.dispose();
    }

    private void dumpState() {
        EObject object = this.getModelObject();
        logger.info("Main object: {}", (Object)object);
        if (object instanceof Symbol && ((Symbol)object).getRoot() != null) {
            logger.info("root name: {}", (Object)((Symbol)object).getRoot().getName());
        }
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.dumpState();
    }

    public void reload() {
        this.dumpState();
        this.updateSymbol();
    }

    @Override
    protected void handleInputChanged(List<Resource> changedResources, List<Resource> removedResources) {
        super.handleInputChanged(changedResources, removedResources);
        this.dumpState();
        this.updateSymbol();
    }

    public void createPartControl(Composite parent) {
        Composite wrapper = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        wrapper.setLayout((Layout)layout);
        this.symbolArea = new Composite(wrapper, 0);
        this.symbolArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.symbolArea.setLayout((Layout)new FillLayout());
        this.updateSymbol();
    }

    private void updateSymbol() {
        Symbol symbol;
        if (this.symbolArea == null) {
            return;
        }
        this.loadedUris.clear();
        if (this.viewer != null) {
            this.viewer.dispose();
            this.viewer = null;
        }
        if ((symbol = this.getSymbol()) != null) {
            HashMap properties = new HashMap();
            StaticSymbolLoader symbolLoader = new StaticSymbolLoader(symbol);
            HashMap scriptObjects = new HashMap();
            this.viewer = new VisualInterfaceViewer(this.symbolArea, 0, (SymbolLoader)symbolLoader, scriptObjects, properties, this.factoryContext);
        }
        this.symbolArea.layout();
    }

    protected ClassLoader getInterfaceClassLoader() {
        return Activator.class.getClassLoader();
    }

    private Symbol getSymbol() {
        EObject o = this.getModelObject();
        if (o instanceof Symbol) {
            return (Symbol)o;
        }
        return null;
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }
}

