/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.setup.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum Parity implements Enumerator
{
    NONE(0, "NONE", "NONE"),
    EVEN(1, "EVEN", "EVEN"),
    ODD(2, "ODD", "ODD");

    public static final int NONE_VALUE = 0;
    public static final int EVEN_VALUE = 1;
    public static final int ODD_VALUE = 2;
    private static final Parity[] VALUES_ARRAY;
    public static final List<Parity> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Parity[]{NONE, EVEN, ODD};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Parity get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Parity result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Parity getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Parity result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Parity get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return EVEN;
            }
            case 2: {
                return ODD;
            }
        }
        return null;
    }

    private Parity(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

