/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.setup.common;

import java.util.Collection;
import java.util.Map;
import org.eclipse.scada.configuration.lib.Properties;
import org.eclipse.scada.configuration.setup.common.Postgres;
import org.eclipse.scada.configuration.setup.common.PostgresSetupModule;
import org.eclipse.scada.configuration.world.setup.OperatingSystemDescriptor;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;

public class PostgresValidator
extends Postgres {
    private final OperatingSystemDescriptor os;
    private final ValidationContext ctx;

    public PostgresValidator(PostgresSetupModule postgres, OperatingSystemDescriptor os, ValidationContext ctx) {
        super(postgres);
        this.os = os;
        this.ctx = ctx;
    }

    public void validate() {
        String version = Properties.get((Collection)this.os.getProperties(), (String)"postgresql.version", null);
        if (version == null) {
            this.ctx.add("Operating system does not provide PostgreSQL", new Object[0]);
        } else if (!"9.3".equals(version)) {
            this.ctx.add("Requires '{0}' = {1} but found ({2})", new Object[]{"postgresql.version", "9.3", version});
        }
        Map props = Properties.makeAttributes((Collection)this.os.getProperties());
        this.getConfigurationFile(props);
        this.getHostBasedAccessFile(props);
    }
}

