/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.ui.launcher.driver;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.da.core.server.Hive;
import org.eclipse.scada.da.core.server.HiveCreator;
import org.eclipse.scada.da.server.exporter.ConfigurationException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleContextHiveFactory {
    private static final Logger logger = LoggerFactory.getLogger(BundleContextHiveFactory.class);
    private final BundleContext context;

    public BundleContextHiveFactory(BundleContext context) {
        this.context = context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Hive createHive(String reference, EObject node) throws ConfigurationException {
        try {
            Collection refs = this.context.getServiceReferences(HiveCreator.class, String.format("(%s=%s)", "eclipse.scada.hiveReferenceType", reference));
            if (refs.isEmpty()) {
                throw new ConfigurationException("Unable to create hive", (Throwable)new IllegalArgumentException(String.format("Hive '%s' is unknown", reference)));
            }
            ServiceReference first = (ServiceReference)refs.iterator().next();
            HiveCreator service = (HiveCreator)this.context.getService(first);
            try {
                logger.debug("Delegating call to: {}", (Object)service);
                Hive result = service.createHive(reference, (Object)node);
                if (result == null) {
                    throw new IllegalArgumentException("Creator did not create hive");
                }
                Hive hive = result;
                return hive;
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to create hive", (Throwable)e);
            }
            finally {
                this.context.ungetService(first);
            }
        }
        catch (InvalidSyntaxException e) {
            throw new ConfigurationException("Failed to locate services", (Throwable)e);
        }
    }
}

