/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.modbus;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ProtocolType implements Enumerator
{
    TCP(0, "TCP", "TCP"),
    RTU(1, "RTU", "RTU");

    public static final int TCP_VALUE = 0;
    public static final int RTU_VALUE = 1;
    private static final ProtocolType[] VALUES_ARRAY;
    public static final List<ProtocolType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ProtocolType[]{TCP, RTU};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ProtocolType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProtocolType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProtocolType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ProtocolType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ProtocolType get(int value) {
        switch (value) {
            case 0: {
                return TCP;
            }
            case 1: {
                return RTU;
            }
        }
        return null;
    }

    private ProtocolType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

