/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.modbus.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.scada.configuration.modbus.ByteOrder;
import org.eclipse.scada.configuration.modbus.ModbusBlock;
import org.eclipse.scada.configuration.modbus.ModbusDevice;
import org.eclipse.scada.configuration.modbus.ModbusDouble;
import org.eclipse.scada.configuration.modbus.ModbusDriver;
import org.eclipse.scada.configuration.modbus.ModbusExporter;
import org.eclipse.scada.configuration.modbus.ModbusExporterDevice;
import org.eclipse.scada.configuration.modbus.ModbusExporterInterceptor;
import org.eclipse.scada.configuration.modbus.ModbusExporterItem;
import org.eclipse.scada.configuration.modbus.ModbusExporterModule;
import org.eclipse.scada.configuration.modbus.ModbusFactory;
import org.eclipse.scada.configuration.modbus.ModbusMaster;
import org.eclipse.scada.configuration.modbus.ModbusPackage;
import org.eclipse.scada.configuration.modbus.ModbusSInt16;
import org.eclipse.scada.configuration.modbus.ModbusSInt32;
import org.eclipse.scada.configuration.modbus.ModbusSlave;
import org.eclipse.scada.configuration.modbus.ModbusUInt16;
import org.eclipse.scada.configuration.modbus.ModbusUInt32;
import org.eclipse.scada.configuration.modbus.ProtocolType;
import org.eclipse.scada.configuration.modbus.impl.ModbusBlockImpl;
import org.eclipse.scada.configuration.modbus.impl.ModbusDeviceImpl;
import org.eclipse.scada.configuration.modbus.impl.ModbusDoubleImpl;
import org.eclipse.scada.configuration.modbus.impl.ModbusDriverImpl;
import org.eclipse.scada.configuration.modbus.impl.ModbusExporterDeviceImpl;
import org.eclipse.scada.configuration.modbus.impl.ModbusExporterImpl;
import org.eclipse.scada.configuration.modbus.impl.ModbusExporterInterceptorImpl;
import org.eclipse.scada.configuration.modbus.impl.ModbusExporterItemImpl;
import org.eclipse.scada.configuration.modbus.impl.ModbusExporterModuleImpl;
import org.eclipse.scada.configuration.modbus.impl.ModbusMasterImpl;
import org.eclipse.scada.configuration.modbus.impl.ModbusSInt16Impl;
import org.eclipse.scada.configuration.modbus.impl.ModbusSInt32Impl;
import org.eclipse.scada.configuration.modbus.impl.ModbusSlaveImpl;
import org.eclipse.scada.configuration.modbus.impl.ModbusUInt16Impl;
import org.eclipse.scada.configuration.modbus.impl.ModbusUInt32Impl;
import org.eclipse.scada.da.server.osgi.modbus.RequestType;

public class ModbusFactoryImpl
extends EFactoryImpl
implements ModbusFactory {
    public static ModbusFactory init() {
        try {
            ModbusFactory theModbusFactory = (ModbusFactory)EPackage.Registry.INSTANCE.getEFactory("http://eclipse.org/SCADA/Configuration/Modbus");
            if (theModbusFactory != null) {
                return theModbusFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ModbusFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createModbusDevice();
            }
            case 1: {
                return this.createModbusDriver();
            }
            case 2: {
                return this.createModbusSlave();
            }
            case 3: {
                return this.createModbusMaster();
            }
            case 4: {
                return this.createModbusBlock();
            }
            case 5: {
                return this.createModbusExporter();
            }
            case 6: {
                return this.createModbusExporterDevice();
            }
            case 7: {
                return this.createModbusExporterItem();
            }
            case 9: {
                return this.createModbusDouble();
            }
            case 10: {
                return this.createModbusSInt16();
            }
            case 11: {
                return this.createModbusSInt32();
            }
            case 12: {
                return this.createModbusUInt16();
            }
            case 13: {
                return this.createModbusUInt32();
            }
            case 14: {
                return this.createModbusExporterModule();
            }
            case 15: {
                return this.createModbusExporterInterceptor();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 16: {
                return this.createProtocolTypeFromString(eDataType, initialValue);
            }
            case 17: {
                return this.createByteOrderFromString(eDataType, initialValue);
            }
            case 18: {
                return this.createRequestTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 16: {
                return this.convertProtocolTypeToString(eDataType, instanceValue);
            }
            case 17: {
                return this.convertByteOrderToString(eDataType, instanceValue);
            }
            case 18: {
                return this.convertRequestTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public ModbusDevice createModbusDevice() {
        ModbusDeviceImpl modbusDevice = new ModbusDeviceImpl();
        return modbusDevice;
    }

    @Override
    public ModbusDriver createModbusDriver() {
        ModbusDriverImpl modbusDriver = new ModbusDriverImpl();
        return modbusDriver;
    }

    @Override
    public ModbusSlave createModbusSlave() {
        ModbusSlaveImpl modbusSlave = new ModbusSlaveImpl();
        return modbusSlave;
    }

    @Override
    public ModbusMaster createModbusMaster() {
        ModbusMasterImpl modbusMaster = new ModbusMasterImpl();
        return modbusMaster;
    }

    @Override
    public ModbusBlock createModbusBlock() {
        ModbusBlockImpl modbusBlock = new ModbusBlockImpl();
        return modbusBlock;
    }

    @Override
    public ModbusExporter createModbusExporter() {
        ModbusExporterImpl modbusExporter = new ModbusExporterImpl();
        return modbusExporter;
    }

    @Override
    public ModbusExporterDevice createModbusExporterDevice() {
        ModbusExporterDeviceImpl modbusExporterDevice = new ModbusExporterDeviceImpl();
        return modbusExporterDevice;
    }

    @Override
    public ModbusExporterItem createModbusExporterItem() {
        ModbusExporterItemImpl modbusExporterItem = new ModbusExporterItemImpl();
        return modbusExporterItem;
    }

    @Override
    public ModbusDouble createModbusDouble() {
        ModbusDoubleImpl modbusDouble = new ModbusDoubleImpl();
        return modbusDouble;
    }

    @Override
    public ModbusSInt16 createModbusSInt16() {
        ModbusSInt16Impl modbusSInt16 = new ModbusSInt16Impl();
        return modbusSInt16;
    }

    @Override
    public ModbusSInt32 createModbusSInt32() {
        ModbusSInt32Impl modbusSInt32 = new ModbusSInt32Impl();
        return modbusSInt32;
    }

    @Override
    public ModbusUInt16 createModbusUInt16() {
        ModbusUInt16Impl modbusUInt16 = new ModbusUInt16Impl();
        return modbusUInt16;
    }

    @Override
    public ModbusUInt32 createModbusUInt32() {
        ModbusUInt32Impl modbusUInt32 = new ModbusUInt32Impl();
        return modbusUInt32;
    }

    @Override
    public ModbusExporterModule createModbusExporterModule() {
        ModbusExporterModuleImpl modbusExporterModule = new ModbusExporterModuleImpl();
        return modbusExporterModule;
    }

    @Override
    public ModbusExporterInterceptor createModbusExporterInterceptor() {
        ModbusExporterInterceptorImpl modbusExporterInterceptor = new ModbusExporterInterceptorImpl();
        return modbusExporterInterceptor;
    }

    public ProtocolType createProtocolTypeFromString(EDataType eDataType, String initialValue) {
        ProtocolType result = ProtocolType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertProtocolTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public ByteOrder createByteOrderFromString(EDataType eDataType, String initialValue) {
        ByteOrder result = ByteOrder.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertByteOrderToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public RequestType createRequestTypeFromString(EDataType eDataType, String initialValue) {
        return (RequestType)super.createFromString(eDataType, initialValue);
    }

    public String convertRequestTypeToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    @Override
    public ModbusPackage getModbusPackage() {
        return (ModbusPackage)this.getEPackage();
    }

    @Deprecated
    public static ModbusPackage getPackage() {
        return ModbusPackage.eINSTANCE;
    }
}

