/*******************************************************************************
 * Copyright (c) 2013 IBH SYSTEMS GmbH and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBH SYSTEMS GmbH - initial API and implementation
 *******************************************************************************/
package org.eclipse.scada.configuration.memory.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IItemStyledLabelProvider;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.scada.configuration.memory.util.MemoryAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class MemoryItemProviderAdapterFactory extends MemoryAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable
{
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier ();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object> ();

    /**
     * This constructs an instance.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public MemoryItemProviderAdapterFactory ()
    {
        supportedTypes.add ( IEditingDomainItemProvider.class );
        supportedTypes.add ( IStructuredItemContentProvider.class );
        supportedTypes.add ( ITreeItemContentProvider.class );
        supportedTypes.add ( IItemLabelProvider.class );
        supportedTypes.add ( IItemPropertySource.class );
        supportedTypes.add ( IItemStyledLabelProvider.class );
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.TypeDefinition} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TypeDefinitionItemProvider typeDefinitionItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.TypeDefinition}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTypeDefinitionAdapter ()
    {
        if ( typeDefinitionItemProvider == null )
        {
            typeDefinitionItemProvider = new TypeDefinitionItemProvider ( this );
        }

        return typeDefinitionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.BitType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected BitTypeItemProvider bitTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.BitType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createBitTypeAdapter ()
    {
        if ( bitTypeItemProvider == null )
        {
            bitTypeItemProvider = new BitTypeItemProvider ( this );
        }

        return bitTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.Variable} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected VariableItemProvider variableItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.Variable}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createVariableAdapter ()
    {
        if ( variableItemProvider == null )
        {
            variableItemProvider = new VariableItemProvider ( this );
        }

        return variableItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.Attribute} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected AttributeItemProvider attributeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.Attribute}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createAttributeAdapter ()
    {
        if ( attributeItemProvider == null )
        {
            attributeItemProvider = new AttributeItemProvider ( this );
        }

        return attributeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.Float32Type} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Float32TypeItemProvider float32TypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.Float32Type}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createFloat32TypeAdapter ()
    {
        if ( float32TypeItemProvider == null )
        {
            float32TypeItemProvider = new Float32TypeItemProvider ( this );
        }

        return float32TypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.UserDefinedType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected UserDefinedTypeItemProvider userDefinedTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.UserDefinedType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createUserDefinedTypeAdapter ()
    {
        if ( userDefinedTypeItemProvider == null )
        {
            userDefinedTypeItemProvider = new UserDefinedTypeItemProvider ( this );
        }

        return userDefinedTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.UnsignedInteger16Type} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected UnsignedInteger16TypeItemProvider unsignedInteger16TypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.UnsignedInteger16Type}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createUnsignedInteger16TypeAdapter ()
    {
        if ( unsignedInteger16TypeItemProvider == null )
        {
            unsignedInteger16TypeItemProvider = new UnsignedInteger16TypeItemProvider ( this );
        }

        return unsignedInteger16TypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.UnsignedInteger32Type} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected UnsignedInteger32TypeItemProvider unsignedInteger32TypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.UnsignedInteger32Type}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createUnsignedInteger32TypeAdapter ()
    {
        if ( unsignedInteger32TypeItemProvider == null )
        {
            unsignedInteger32TypeItemProvider = new UnsignedInteger32TypeItemProvider ( this );
        }

        return unsignedInteger32TypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.UnsignedInteger8Type} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected UnsignedInteger8TypeItemProvider unsignedInteger8TypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.UnsignedInteger8Type}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createUnsignedInteger8TypeAdapter ()
    {
        if ( unsignedInteger8TypeItemProvider == null )
        {
            unsignedInteger8TypeItemProvider = new UnsignedInteger8TypeItemProvider ( this );
        }

        return unsignedInteger8TypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.TypeSystem} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TypeSystemItemProvider typeSystemItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.TypeSystem}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createTypeSystemAdapter ()
    {
        if ( typeSystemItemProvider == null )
        {
            typeSystemItemProvider = new TypeSystemItemProvider ( this );
        }

        return typeSystemItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.Float64Type} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Float64TypeItemProvider float64TypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.Float64Type}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createFloat64TypeAdapter ()
    {
        if ( float64TypeItemProvider == null )
        {
            float64TypeItemProvider = new Float64TypeItemProvider ( this );
        }

        return float64TypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.SignedInteger8Type} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SignedInteger8TypeItemProvider signedInteger8TypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.SignedInteger8Type}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSignedInteger8TypeAdapter ()
    {
        if ( signedInteger8TypeItemProvider == null )
        {
            signedInteger8TypeItemProvider = new SignedInteger8TypeItemProvider ( this );
        }

        return signedInteger8TypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.SignedInteger16Type} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SignedInteger16TypeItemProvider signedInteger16TypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.SignedInteger16Type}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSignedInteger16TypeAdapter ()
    {
        if ( signedInteger16TypeItemProvider == null )
        {
            signedInteger16TypeItemProvider = new SignedInteger16TypeItemProvider ( this );
        }

        return signedInteger16TypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.SignedInteger32Type} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SignedInteger32TypeItemProvider signedInteger32TypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.SignedInteger32Type}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSignedInteger32TypeAdapter ()
    {
        if ( signedInteger32TypeItemProvider == null )
        {
            signedInteger32TypeItemProvider = new SignedInteger32TypeItemProvider ( this );
        }

        return signedInteger32TypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.SignedInteger64Type} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected SignedInteger64TypeItemProvider signedInteger64TypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.SignedInteger64Type}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createSignedInteger64TypeAdapter ()
    {
        if ( signedInteger64TypeItemProvider == null )
        {
            signedInteger64TypeItemProvider = new SignedInteger64TypeItemProvider ( this );
        }

        return signedInteger64TypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.FixedLengthStringType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected FixedLengthStringTypeItemProvider fixedLengthStringTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.FixedLengthStringType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createFixedLengthStringTypeAdapter ()
    {
        if ( fixedLengthStringTypeItemProvider == null )
        {
            fixedLengthStringTypeItemProvider = new FixedLengthStringTypeItemProvider ( this );
        }

        return fixedLengthStringTypeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link org.eclipse.scada.configuration.memory.FixedLengthBlobType} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected FixedLengthBlobTypeItemProvider fixedLengthBlobTypeItemProvider;

    /**
     * This creates an adapter for a {@link org.eclipse.scada.configuration.memory.FixedLengthBlobType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createFixedLengthBlobTypeAdapter ()
    {
        if ( fixedLengthBlobTypeItemProvider == null )
        {
            fixedLengthBlobTypeItemProvider = new FixedLengthBlobTypeItemProvider ( this );
        }

        return fixedLengthBlobTypeItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ComposeableAdapterFactory getRootAdapterFactory ()
    {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory ();
    }

    /**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setParentAdapterFactory ( ComposedAdapterFactory parentAdapterFactory )
    {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean isFactoryForType ( Object type )
    {
        return supportedTypes.contains ( type ) || super.isFactoryForType ( type );
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter adapt ( Notifier notifier, Object type )
    {
        return super.adapt ( notifier, this );
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object adapt ( Object object, Object type )
    {
        if ( isFactoryForType ( type ) )
        {
            Object adapter = super.adapt ( object, type );
            if ( ! ( type instanceof Class<?> ) || ( ( (Class<?>)type ).isInstance ( adapter ) ) )
            {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void addListener ( INotifyChangedListener notifyChangedListener )
    {
        changeNotifier.addListener ( notifyChangedListener );
    }

    /**
     * This removes a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void removeListener ( INotifyChangedListener notifyChangedListener )
    {
        changeNotifier.removeListener ( notifyChangedListener );
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void fireNotifyChanged ( Notification notification )
    {
        changeNotifier.fireNotifyChanged ( notification );

        if ( parentAdapterFactory != null )
        {
            parentAdapterFactory.fireNotifyChanged ( notification );
        }
    }

    /**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void dispose ()
    {
        if ( typeDefinitionItemProvider != null )
            typeDefinitionItemProvider.dispose ();
        if ( bitTypeItemProvider != null )
            bitTypeItemProvider.dispose ();
        if ( variableItemProvider != null )
            variableItemProvider.dispose ();
        if ( attributeItemProvider != null )
            attributeItemProvider.dispose ();
        if ( float32TypeItemProvider != null )
            float32TypeItemProvider.dispose ();
        if ( userDefinedTypeItemProvider != null )
            userDefinedTypeItemProvider.dispose ();
        if ( unsignedInteger16TypeItemProvider != null )
            unsignedInteger16TypeItemProvider.dispose ();
        if ( unsignedInteger32TypeItemProvider != null )
            unsignedInteger32TypeItemProvider.dispose ();
        if ( unsignedInteger8TypeItemProvider != null )
            unsignedInteger8TypeItemProvider.dispose ();
        if ( typeSystemItemProvider != null )
            typeSystemItemProvider.dispose ();
        if ( float64TypeItemProvider != null )
            float64TypeItemProvider.dispose ();
        if ( signedInteger8TypeItemProvider != null )
            signedInteger8TypeItemProvider.dispose ();
        if ( signedInteger16TypeItemProvider != null )
            signedInteger16TypeItemProvider.dispose ();
        if ( signedInteger32TypeItemProvider != null )
            signedInteger32TypeItemProvider.dispose ();
        if ( signedInteger64TypeItemProvider != null )
            signedInteger64TypeItemProvider.dispose ();
        if ( fixedLengthStringTypeItemProvider != null )
            fixedLengthStringTypeItemProvider.dispose ();
        if ( fixedLengthBlobTypeItemProvider != null )
            fixedLengthBlobTypeItemProvider.dispose ();
    }

}
