/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.lib;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.lib.Nodes;
import org.eclipse.scada.configuration.world.Application;
import org.eclipse.scada.configuration.world.ContainedServiceBinding;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.Node;
import org.eclipse.scada.configuration.world.ReferencedServiceBinding;
import org.eclipse.scada.configuration.world.ServiceBinding;
import org.eclipse.scada.configuration.world.WorldFactory;

public final class Endpoints {
    private Endpoints() {
    }

    public static Endpoint registerEndpoint(Application app, int port, ServiceBinding serviceBinding, String name) {
        return Endpoints.registerEndpoint(Nodes.fromApp(app), port, serviceBinding, name);
    }

    public static Endpoint registerEndpoint(Node node, int port, ServiceBinding serviceBinding, String name) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Trying to add port %d (%s) to void node", port, name));
        }
        Endpoint ep = Endpoints.findEndpoint(node, port);
        if (ep != null && ep.getBoundService() != null && serviceBinding != null) {
            String oldService = Endpoints.makeLabel(ep.getBoundService());
            String newService = Endpoints.makeLabel(serviceBinding);
            throw new IllegalStateException(String.format("Endpoint %s already exists on node %s and is bound by %s (re-binding service: %s)", port, Nodes.makeName(node), oldService, newService));
        }
        if (ep == null) {
            ep = Endpoints.createEndpoint(port, name);
            node.getEndpoints().add((Object)ep);
        }
        Endpoints.bind(ep, serviceBinding);
        if (serviceBinding != null) {
            ep.setName(name);
        }
        return ep;
    }

    protected static String makeLabel(ServiceBinding serviceBinding) {
        EObject s = serviceBinding.getService();
        if (s == null) {
            return "<unknown>";
        }
        if (s instanceof NamedDocumentable) {
            StringBuilder sb = new StringBuilder();
            NamedDocumentable nd = (NamedDocumentable)s;
            sb.append(s.eClass().getName());
            sb.append(" (");
            sb.append(nd.getName());
            if (nd.getShortDescription() != null) {
                sb.append(" - ").append(nd.getShortDescription());
            }
            sb.append(')');
            return sb.toString();
        }
        return serviceBinding.getService().toString();
    }

    public static ServiceBinding reference(EObject service) {
        ReferencedServiceBinding result = WorldFactory.eINSTANCE.createReferencedServiceBinding();
        result.setService(service);
        return result;
    }

    public static ServiceBinding contain(EObject service) {
        ContainedServiceBinding result = WorldFactory.eINSTANCE.createContainedServiceBinding();
        result.setService(service);
        return result;
    }

    private static Endpoint createEndpoint(int port, String name) {
        Endpoint ep = WorldFactory.eINSTANCE.createEndpoint();
        ep.setPortNumber(port);
        ep.setName(name);
        return ep;
    }

    public static Node findNode(Endpoint ep) {
        if (ep.eContainer() instanceof Node) {
            return (Node)ep.eContainer();
        }
        return null;
    }

    public static <N extends Node> N findNode(Endpoint ep, Class<N> clazz) {
        Node node = Endpoints.findNode(ep);
        if (node != null && clazz.isAssignableFrom(node.getClass())) {
            return (N)((Node)clazz.cast(node));
        }
        throw new IllegalStateException(String.format("Endpoint %s is not contained by node of type %s", ep, clazz.getName()));
    }

    public static Endpoint findEndpoint(Node node, int port) {
        for (Endpoint ep : node.getEndpoints()) {
            if (ep.getPortNumber() != port) continue;
            return ep;
        }
        return null;
    }

    public static void bind(Endpoint ep, ServiceBinding serviceBinding) {
        if (serviceBinding == null) {
            return;
        }
        ep.setBoundService(serviceBinding);
    }

    public static ServiceBinding binding(EObject service) {
        if (service == null) {
            return null;
        }
        if (service.eContainer() != null) {
            return Endpoints.reference(service);
        }
        return Endpoints.contain(service);
    }
}

