/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.lib;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.Node;
import org.eclipse.scada.configuration.world.osgi.Connection;
import org.eclipse.scada.configuration.world.osgi.DataAccessConnection;
import org.eclipse.scada.configuration.world.osgi.DataAccessExporter;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.Exporter;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Locator {
    private static final Logger logger = LoggerFactory.getLogger(Locator.class);

    private Locator() {
    }

    public static Collection<Endpoint> findLocalEndpoints(Exporter exp) {
        if (!(exp.eContainer() instanceof EquinoxApplication)) {
            return Collections.emptyList();
        }
        EquinoxApplication app = (EquinoxApplication)exp.eContainer();
        if (!(app.eContainer() instanceof Node)) {
            return Collections.emptyList();
        }
        return ((Node)app.eContainer()).getEndpoints();
    }

    public static <T extends Connection> List<T> findConnections(EquinoxApplication app, Class<T> clazz) {
        LinkedList<Connection> result = new LinkedList<Connection>();
        for (Connection connection : app.getConnections()) {
            if (!clazz.isAssignableFrom(connection.getClass())) continue;
            result.add((Connection)clazz.cast(connection));
        }
        return result;
    }

    public static <T extends Connection> List<T> findPossibleConnections(EquinoxApplication from, EquinoxApplication to, Class<T> clazz) {
        LinkedList<Connection> result = new LinkedList<Connection>();
        for (Connection connection : Locator.findConnections(from, clazz)) {
            for (Exporter exporter : to.getExporter()) {
                EList possibleEndpoints = connection.getPossibleEndpoints(exporter);
                if (possibleEndpoints.isEmpty() || !possibleEndpoints.contains((Object)connection.getEndpoint())) continue;
                result.add(connection);
            }
        }
        return result;
    }

    public static <T extends Connection> T findPossibleConnection(EquinoxApplication from, EquinoxApplication to, Class<T> clazz) {
        List<T> result = Locator.findPossibleConnections(from, to, clazz);
        if (result.isEmpty()) {
            throw new IllegalStateException(String.format("There must be exactly one connection of type %s. There is none.", clazz.getName()));
        }
        if (result.size() > 1) {
            throw new IllegalStateException(String.format("There must be exactly one connection of type %s. There are %s.", clazz.getName(), result.size()));
        }
        return (T)((Connection)result.get(0));
    }

    public static <T extends Exporter> List<T> findExporters(EObject start, Class<T> clazz) {
        if (!(start.eContainer() instanceof MasterServer)) {
            return null;
        }
        LinkedList<Exporter> result = new LinkedList<Exporter>();
        for (Exporter exporter : ((MasterServer)start.eContainer()).getExporter()) {
            if (!clazz.isAssignableFrom(exporter.getClass())) continue;
            result.add((Exporter)clazz.cast(exporter));
        }
        return result;
    }

    public static <T extends Exporter> T findExporter(EObject start, Class<T> clazz) {
        List<T> result = Locator.findExporters(start, clazz);
        if (result.isEmpty()) {
            throw new IllegalStateException(String.format("There must be exactly one exporter of type %s. There is none.", clazz.getName()));
        }
        if (result.size() > 1) {
            throw new IllegalStateException(String.format("There must be exactly one exporter of type %s. There are %s.", clazz.getName(), result.size()));
        }
        return (T)((Exporter)result.get(0));
    }

    public static <T extends EquinoxApplication> T findApplication(EObject start, Class<T> clazz) {
        EObject current = start;
        while (current != null) {
            if (clazz.isAssignableFrom(current.getClass())) {
                return (T)((EquinoxApplication)clazz.cast(current));
            }
            current = current.eContainer();
        }
        return null;
    }

    public static Connection findConnection(EquinoxApplication source, Collection<Endpoint> target) {
        if (source == null) {
            return null;
        }
        for (Endpoint ep : target) {
            for (Connection connection : source.getConnections()) {
                if (connection.getEndpoint() == null || !connection.getEndpoint().equals(ep)) continue;
                return connection;
            }
        }
        return null;
    }

    public static List<Endpoint> getSelfEndpoints(MasterServer master) {
        LinkedList<Endpoint> result = new LinkedList<Endpoint>();
        if (master == null) {
            return result;
        }
        HashMap<Endpoint, Exporter> map = new HashMap<Endpoint, Exporter>();
        for (Exporter exp : master.getExporter()) {
            if (!(exp instanceof DataAccessExporter)) continue;
            for (Endpoint endp : exp.getEndpoints()) {
                logger.debug("Recording endpoint - exporter {} -> {}", (Object)exp.getName(), (Object)endp.getName());
                map.put(endp, exp);
            }
        }
        for (Connection con : master.getConnections()) {
            Exporter exporter;
            if (!(con instanceof DataAccessConnection) || (exporter = (Exporter)map.get(con.getEndpoint())) == null) continue;
            logger.debug("Connection points to - exporter: {}, endpoint: {}", (Object)exporter.getName(), (Object)con.getEndpoint().getName());
            result.add(con.getEndpoint());
        }
        if (result.isEmpty()) {
            throw new IllegalStateException("There is no connection to the local application instance. Create a DataAccess connection from the application to its own exporter.");
        }
        return result;
    }

    public static Connection findConnection(MasterServer master, String name, Class<DataAccessConnection> clazz) {
        for (Connection c : master.getConnections()) {
            if (!clazz.isAssignableFrom(c.getClass()) || !c.getName().equals(name)) continue;
            return c;
        }
        throw new IllegalStateException(String.format("Unable to find a connection named '%s' of ype %s on %s", name, clazz.getName(), master));
    }
}

