/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.item.parser;

import com.google.common.io.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;

public abstract class ScriptResourceImpl
extends ResourceImpl {
    protected final String fileExtension;
    protected final String defaultCharacterSet;
    protected final String scriptEngine;

    public ScriptResourceImpl(URI uri, String scriptEngine, String fileExtension, String defaultCharacterSet) {
        super(uri);
        this.scriptEngine = scriptEngine;
        this.fileExtension = fileExtension;
        this.defaultCharacterSet = defaultCharacterSet;
    }

    protected abstract void write(OutputStreamWriter var1) throws IOException;

    protected abstract EObject parse(String var1);

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        try {
            String data = CharStreams.toString((Readable)new InputStreamReader(inputStream, this.defaultCharacterSet));
            this.getContents().add((Object)this.parse(data));
        }
        finally {
            inputStream.close();
        }
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (OutputStreamWriter writer = new OutputStreamWriter(outputStream, this.defaultCharacterSet);){
                this.write(writer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            outputStream.close();
        }
    }
}

