/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.item.parser.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class FileCreationPage
extends WizardNewFileCreationPage {
    private final String requiredExtension;

    public FileCreationPage(String pageName, IStructuredSelection selection, String requiredExtension) {
        super(pageName, selection);
        this.requiredExtension = requiredExtension;
    }

    protected boolean validatePage() {
        if (super.validatePage()) {
            String extension = new Path(this.getFileName()).getFileExtension();
            if (extension == null || !this.requiredExtension.equals(extension)) {
                this.setErrorMessage(String.format("File must have the requiredExtension '.%s'", this.requiredExtension));
                return false;
            }
            return true;
        }
        return false;
    }

    public IFile getFile() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.getContainerFullPath().append(this.getFileName()));
    }
}

