/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.setup.common.lib;

import com.google.common.io.Resources;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.scada.configuration.setup.common.SerialToNetwork;
import org.eclipse.scada.configuration.setup.common.SerialToNetworkMapping;
import org.eclipse.scada.configuration.setup.common.SerialToNetworkSetupModule;
import org.eclipse.scada.configuration.world.lib.deployment.DeploymentContext;
import org.eclipse.scada.configuration.world.lib.deployment.FileInformation;
import org.eclipse.scada.configuration.world.lib.deployment.FileOptions;
import org.eclipse.scada.configuration.world.lib.deployment.OperatingSystemDescriptors;
import org.eclipse.scada.configuration.world.lib.setup.SetupModuleHandler;
import org.eclipse.scada.configuration.world.setup.OperatingSystemDescriptor;
import org.eclipse.scada.utils.pkg.deb.ContentProvider;
import org.eclipse.scada.utils.pkg.deb.StaticContentProvider;
import org.eclipse.scada.utils.str.StringHelper;
import org.eclipse.scada.utils.str.StringReplacer;

public class SerialToNetworkHandler
implements SetupModuleHandler {
    private static final Pattern PATTERN = Pattern.compile("@@(.*?)@@");
    private final SerialToNetworkSetupModule target;

    public SerialToNetworkHandler(SerialToNetworkSetupModule target) {
        this.target = target;
    }

    public void perform(DeploymentContext context, OperatingSystemDescriptor operatingSystem) throws Exception {
        SerialToNetwork.validate((SerialToNetworkSetupModule)this.target, (OperatingSystemDescriptor)operatingSystem);
        StringBuilder sb = new StringBuilder();
        sb.append("# Configuration file create by Eclipse SCADA Configurator IDE");
        sb.append('\n').append('\n');
        for (SerialToNetworkMapping entry : this.target.getMappings()) {
            sb.append(String.format("%s:raw:%s:%s:%s", entry.getTcpPort(), Math.max(0, entry.getTimeout()), entry.getDevice(), this.makeOptions(entry)));
            sb.append('\n');
        }
        context.addFile((ContentProvider)new StaticContentProvider(sb.toString()), "/etc/site/ser2net.conf", new FileInformation(Integer.valueOf(3360), null, null, new FileOptions[]{FileOptions.CONFIGURATION}));
        this.divert(context, context.getPackageName(), "/etc/ser2net.conf", "/etc/site/ser2net.conf");
        context.addInstallDependency(OperatingSystemDescriptors.getProperty((OperatingSystemDescriptor)operatingSystem, (String)"ser2net.package", (String)"ser2net"));
        context.runAfterInstallation("/etc/init.d/ser2net restart || true");
        context.runAfterRemoval("/etc/init.d/ser2net restart || true");
    }

    private void divert(DeploymentContext context, String packageName, String targetFile, String diversionFile) throws IOException {
        HashMap<String, String> properties = new HashMap<String, String>(3);
        properties.put("PKG", packageName);
        properties.put("TARGET", targetFile);
        properties.put("DIVERSION", diversionFile);
        context.addPostInstallationScript((Reader)this.makeScript(properties, "dpkg-divert.add.txt"));
        context.addPostRemovalScript((Reader)this.makeScript(properties, "dpkg-divert.remove.txt"));
    }

    protected StringReader makeScript(Map<String, String> properties, String resourceName) throws IOException {
        return new StringReader(StringReplacer.replace((String)Resources.toString((URL)this.getClass().getResource(resourceName), (Charset)StandardCharsets.UTF_8), (StringReplacer.ReplaceSource)StringReplacer.newSource(properties), (Pattern)PATTERN));
    }

    private String makeOptions(SerialToNetworkMapping entry) {
        LinkedList<String> options = new LinkedList<String>();
        options.add("" + entry.getBaudRate());
        options.add(String.valueOf(entry.getDataBits()) + "DATABITS");
        options.add(MessageFormat.format("{0,choice,1#1STOPBIT|1<{0}STOPBITS}", entry.getStopBits()));
        options.add("" + entry.getParity());
        if (!entry.isBreak()) {
            options.add("NOBREAK");
        }
        this.addOption(options, !entry.isModemControl(), "LOCAL");
        this.addOption(options, entry.isXonxoff(), "XONXOFF");
        this.addOption(options, entry.isRtscts(), "RTSCTS");
        return StringHelper.join(options, (String)" ");
    }

    private void addOption(List<String> options, boolean flag, String string) {
        if (flag) {
            options.add(string);
        } else {
            options.add("-" + string);
        }
    }
}

