/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.edit;

import java.util.LinkedList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.scada.configuration.component.Level;
import org.eclipse.scada.utils.str.StringHelper;
import org.eclipse.swt.graphics.Image;

public class ComponentLabelProvider
extends LabelProvider {
    private final AdapterFactory adapterFactory;

    public ComponentLabelProvider(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public Image getImage(Object element) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(element, IItemLabelProvider.class);
        if (labelProvider != null) {
            return ExtendedImageRegistry.getInstance().getImage(labelProvider.getImage(element));
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        IItemLabelProvider labelProvider = (IItemLabelProvider)this.adapterFactory.adapt(element, IItemLabelProvider.class);
        if (labelProvider != null) {
            String label = labelProvider.getText(element);
            String parents = this.makeParents(element);
            if (parents != null && !parents.isEmpty()) {
                return String.valueOf(label) + " - " + parents;
            }
            return label;
        }
        return super.getText(element);
    }

    private String makeParents(Object element) {
        if (!(element instanceof EObject)) {
            return null;
        }
        LinkedList<String> hierarchy = new LinkedList<String>();
        EObject current = ((EObject)element).eContainer();
        while (current instanceof Level) {
            hierarchy.add(0, ((Level)current).getName());
            current = current.eContainer();
        }
        return StringHelper.join(hierarchy, (String)".");
    }
}

