/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.validation;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.scada.configuration.infrastructure.EventInjectorHttp;
import org.eclipse.scada.configuration.infrastructure.HttpServiceModule;
import org.eclipse.scada.configuration.infrastructure.HttpServices;
import org.eclipse.scada.configuration.infrastructure.InfrastructurePackage;
import org.eclipse.scada.configuration.infrastructure.WebAdminConsole;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;
import org.eclipse.scada.utils.ecore.validation.Validator;

public class HttpServiceValidator
implements Validator {
    public void validate(ValidationContext context) {
        if (context.getTarget() instanceof WebAdminConsole) {
            this.performValidation((EObject)((WebAdminConsole)context.getTarget()), (EStructuralFeature)InfrastructurePackage.Literals.WEB_ADMIN_CONSOLE__HTTP_SERVICE, context);
        } else if (context.getTarget() instanceof EventInjectorHttp) {
            this.performValidation((EObject)((EventInjectorHttp)context.getTarget()), (EStructuralFeature)InfrastructurePackage.Literals.EVENT_INJECTOR_HTTP__HTTP_SERVICE, context);
        }
    }

    protected void performValidation(EObject target, EStructuralFeature feature, ValidationContext ctx) {
        Object service = target.eGet(feature);
        if (service == null) {
            return;
        }
        if (!(service instanceof HttpServiceModule)) {
            throw new IllegalStateException(String.format("Validator can only handle %s", HttpServiceModule.class.getName()));
        }
        if (!HttpServices.isValid((Object)target, (HttpServiceModule)((HttpServiceModule)service))) {
            ctx.add(feature, "Selected HTTP Service is not present in the target application setup. The selected service must be either a module in the same application or in the selected configuration of the application.", new Object[0]);
        }
    }
}

