/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.scada.configuration.infrastructure.InfrastructurePackage;
import org.eclipse.scada.configuration.infrastructure.Node;
import org.eclipse.scada.utils.ecore.validation.TypedValidator;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;

public class NodeValidator
extends TypedValidator<Node> {
    private static final Pattern HOSTNAME_PATTERN = Pattern.compile("[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*\\.?");

    public NodeValidator() {
        super(Node.class);
    }

    protected void validate(Node target, ValidationContext context) {
        if (target.getHostName() == null) {
            return;
        }
        Matcher m = HOSTNAME_PATTERN.matcher(target.getHostName());
        if (!m.matches()) {
            context.add((EStructuralFeature)InfrastructurePackage.Literals.NODE__HOST_NAME, "Hostname \"{0}\" does not match pattern \"{1}\"", new Object[]{target.getHostName(), HOSTNAME_PATTERN.pattern()});
        }
    }
}

