/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.scada.configuration.infrastructure.InfrastructurePackage;
import org.eclipse.scada.configuration.infrastructure.OracleVMSettings;
import org.eclipse.scada.utils.ecore.validation.TypedValidator;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;

public class OracleVMSettingsValidator
extends TypedValidator<OracleVMSettings> {
    private static final Pattern MEM_PATTERN = Pattern.compile("([0-9]+)([mk]?)");

    public OracleVMSettingsValidator() {
        super(OracleVMSettings.class);
    }

    protected void validate(OracleVMSettings target, ValidationContext context) {
        this.validateMemoryString(context, target, target.getInitialHeapSize(), InfrastructurePackage.Literals.ORACLE_VM_SETTINGS__INITIAL_HEAP_SIZE, "Initial heap size");
        this.validateMemoryString(context, target, target.getMaximumHeapSize(), InfrastructurePackage.Literals.ORACLE_VM_SETTINGS__MAXIMUM_HEAP_SIZE, "Maximum heap size");
    }

    private void validateMemoryString(ValidationContext ctx, OracleVMSettings target, String memoryValue, EAttribute feature, String string) {
        if (memoryValue == null || memoryValue.isEmpty()) {
            return;
        }
        Matcher m = MEM_PATTERN.matcher(memoryValue);
        if (!m.matches()) {
            ctx.add((EStructuralFeature)feature, "{0} must have the format '<size>m', '<size>k' or '<size>'", new Object[]{string});
            return;
        }
        long value = Long.parseLong(m.group(1));
        String unit = m.group(2);
        if ("k".equals(unit)) {
            value *= 1024L;
        } else if ("m".equals(unit)) {
            value = value * 1024L * 1024L;
        }
        if (value <= 0L) {
            ctx.add((EStructuralFeature)feature, "{0} must be greater than zero", new Object[]{string});
        }
    }
}

