/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.ui.component;

import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.viewers.ObservableSetTreeContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.scada.configuration.ui.component.Activator;
import org.eclipse.scada.configuration.ui.component.ComponentOutputObservableFactory;
import org.eclipse.scada.configuration.ui.component.Helper;
import org.eclipse.scada.configuration.ui.component.NameLabelProvider;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.OsgiPackage;
import org.eclipse.scada.ui.databinding.ObservableMapStyledCellLabelProvider;
import org.eclipse.scada.utils.core.runtime.AdapterHelper;
import org.eclipse.scada.utils.str.StringHelper;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ComponentOutputDialog
extends Dialog {
    private TreeViewer viewer;
    private final IObservableSet input;
    private ObservableSetTreeContentProvider contentProvider;

    protected ComponentOutputDialog(IShellProvider parentShell, IObservableSet input) {
        super(parentShell);
        this.input = input;
        this.setBlockOnOpen(false);
    }

    public ComponentOutputDialog(Shell parentShell, IObservableSet input) {
        super(parentShell);
        this.input = input;
        this.setBlockOnOpen(false);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, true);
    }

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return DialogSettings.getOrCreateSection((IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"componentOutputDialog");
    }

    protected void buttonPressed(int buttonId) {
        this.okPressed();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Component Output");
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new FillLayout());
        TableLayout layout = new TableLayout();
        this.viewer = new TreeViewer(composite, 66308);
        this.viewer.setAutoExpandLevel(2);
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLayout((Layout)layout);
        this.contentProvider = new ObservableSetTreeContentProvider((IObservableFactory)new ComponentOutputObservableFactory(), null);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        TreeViewerColumn col1 = new TreeViewerColumn(this.viewer, 0);
        col1.getColumn().setText("Name");
        col1.setLabelProvider((CellLabelProvider)new NameLabelProvider(this.getShell().getDisplay(), this.contentProvider.getKnownElements()));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(150));
        IObservableMap map = PojoProperties.value((String)"item").observeDetail(this.contentProvider.getKnownElements());
        IObservableMap map2 = EMFProperties.value((EStructuralFeature)OsgiPackage.Literals.ITEM__NAME).observeDetail(map);
        TreeViewerColumn col2 = new TreeViewerColumn(this.viewer, 0);
        col2.getColumn().setText("Item ID");
        col2.setLabelProvider((CellLabelProvider)new ObservableMapStyledCellLabelProvider(map2));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(150));
        map = PojoProperties.value((String)"item").observeDetail(this.contentProvider.getKnownElements());
        map2 = EMFProperties.value((EStructuralFeature)OsgiPackage.Literals.ITEM__INFORMATION).observeDetail(map);
        IObservableMap map3 = EMFProperties.value((EStructuralFeature)OsgiPackage.Literals.ITEM_INFORMATION__DESCRIPTION).observeDetail(map2);
        TreeViewerColumn col22 = new TreeViewerColumn(this.viewer, 0);
        col22.getColumn().setText("Description");
        col22.setLabelProvider((CellLabelProvider)new ObservableMapStyledCellLabelProvider(map3));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        map = PojoProperties.value((String)"customizationRequest").observeDetail(this.contentProvider.getKnownElements());
        map2 = PojoProperties.value((String)"globalizationLevel").observeDetail(map);
        col2 = new TreeViewerColumn(this.viewer, 0);
        col2.getColumn().setText("GL");
        col2.setLabelProvider((CellLabelProvider)new ObservableMapStyledCellLabelProvider(map2));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25));
        map = PojoProperties.value((String)"item").observeDetail(this.contentProvider.getKnownElements());
        TreeViewerColumn col23 = new TreeViewerColumn(this.viewer, 0);
        col23.getColumn().setText("Type");
        col23.setLabelProvider((CellLabelProvider)new ObservableMapStyledCellLabelProvider(map){

            public void update(ViewerCell cell) {
                Object element = cell.getElement();
                Item value = (Item)this.attributeMaps[0].get(element);
                if (value == null) {
                    return;
                }
                StyledString s = new StyledString();
                s.append(value.eClass().getName());
                s.append(String.format(" (%s)", value.eClass().getEPackage().getName()), StyledString.QUALIFIER_STYLER);
                cell.setText(s.getString());
                cell.setStyleRanges(s.getStyleRanges());
            }
        });
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        this.viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ComponentOutputDialog.this.handleDispose();
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                Helper.ItemEntry i2;
                Helper.ItemEntry i1 = (Helper.ItemEntry)AdapterHelper.adapt((Object)e1, Helper.ItemEntry.class);
                if (i1 == (i2 = (Helper.ItemEntry)AdapterHelper.adapt((Object)e2, Helper.ItemEntry.class))) {
                    return 0;
                }
                if (i1 == null) {
                    return -1;
                }
                return StringHelper.join(i1.getLocal(), (String)".").compareTo(StringHelper.join(i2.getLocal(), (String)"."));
            }
        });
        this.viewer.setInput((Object)this.input);
        return composite;
    }

    protected void handleDispose() {
        this.contentProvider.dispose();
        this.input.dispose();
    }
}

