/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.ui.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.DataComponent;
import org.eclipse.scada.configuration.component.lib.Components;
import org.eclipse.scada.configuration.component.lib.create.AbstractComponentItemCreator;
import org.eclipse.scada.configuration.component.lib.create.ItemCreator;
import org.eclipse.scada.configuration.component.lib.create.ItemSource;
import org.eclipse.scada.configuration.component.lib.create.ItemSources;
import org.eclipse.scada.configuration.component.lib.create.MasterListener;
import org.eclipse.scada.configuration.infrastructure.MasterServer;
import org.eclipse.scada.configuration.item.CustomizationRequest;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper {
    private static final Logger logger = LoggerFactory.getLogger(Helper.class);

    public static IObservableSet createObversableInput(Realm realm, Component component) {
        if (component instanceof DataComponent) {
            WritableSet result = new WritableSet(realm){

                public synchronized void dispose() {
                    for (Object o : this.wrappedSet) {
                        if (!(o instanceof Master)) continue;
                        ((Master)o).dispose();
                    }
                    super.dispose();
                }
            };
            DataComponent dc = (DataComponent)component;
            for (MasterServer master : dc.getMasterOn()) {
                result.add((Object)new Master(realm, master, (Component)dc));
            }
            return result;
        }
        WritableSet result = new WritableSet(realm);
        Helper.fillWithEntries(component, result);
        return result;
    }

    private static void fillWithEntries(Component component, WritableSet result) {
        logger.debug("Filling result with entries");
        for (Map.Entry<List<String>, ItemEntry> entry : Helper.createOutputFor(component).entrySet()) {
            logger.debug("Adding entry for result - key: {}, value: {}", entry.getKey(), (Object)entry.getValue());
            result.add((Object)entry.getValue());
        }
    }

    private static Map<List<String>, ItemEntry> createOutputFor(Component dc) {
        ItemSource source = ItemSources.createItemSource((Component)dc);
        if (source == null) {
            return Collections.emptyMap();
        }
        HashMap<List<String>, ItemEntry> entries = new HashMap<List<String>, ItemEntry>();
        SpyComponentItemCreatorImpl creator = new SpyComponentItemCreatorImpl(dc, entries);
        logger.debug("Creating items for: {}", (Object)dc);
        source.createItems((ItemCreator)creator);
        return entries;
    }

    public static class ItemEntry {
        public static final String PROP_LOCAL = "local";
        public static final String PROP_ITEM = "item";
        public static final String PROP_CUSTOMIZATION_REQUEST = "customizationRequest";
        private final Item item;
        private final List<String> local;
        private final CustomizationRequest customizationRequest;

        public ItemEntry(List<String> local, Item item, CustomizationRequest customizationRequest) {
            this.local = Collections.unmodifiableList(local);
            this.item = item;
            this.customizationRequest = customizationRequest;
        }

        public Item getItem() {
            return this.item;
        }

        public List<String> getLocal() {
            return this.local;
        }

        public CustomizationRequest getCustomizationRequest() {
            return this.customizationRequest;
        }
    }

    public static class Master {
        private final WritableSet entries;
        private final MasterServer master;

        public Master(Realm realm, MasterServer master, Component component) {
            this.master = master;
            this.entries = new WritableSet(realm);
            Helper.fillWithEntries(component, this.entries);
        }

        public void dispose() {
            this.entries.dispose();
        }

        public IObservableSet getEntries() {
            return this.entries;
        }

        public String toString() {
            return String.format("[Master: %s]", this.master.toString());
        }

        public MasterServer getMaster() {
            return this.master;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.master == null ? 0 : this.master.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Master other = (Master)obj;
            return !(this.master == null ? other.master != null : !this.master.equals(other.master));
        }
    }

    private static final class SpyComponentItemCreatorImpl
    extends AbstractComponentItemCreator {
        private final Map<List<String>, ItemEntry> entries;

        private SpyComponentItemCreatorImpl(Component component, Map<List<String>, ItemEntry> entries) {
            super(component);
            this.entries = entries;
        }

        public void createMarker(IStatus status) {
        }

        protected <T extends Item> void itemAdded(T item, CustomizationRequest customizationRequest, List<String> originalLocalTags, Set<MasterListener<T>> masterListeners) {
            logger.debug("Adding item: {}", item);
            this.entries.put(originalLocalTags, new ItemEntry(originalLocalTags, item, customizationRequest));
        }

        protected void customizeItem(Item item, CustomizationRequest customizationRequest) {
            Components.customizeItem((Component)this.component, (Item)item, (CustomizationRequest)customizationRequest);
        }
    }
}

