/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.ecore.ui;

import java.util.Map;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.scada.configuration.ecore.ui.ExtendedPropertiesSheetSorter;
import org.eclipse.scada.configuration.ecore.ui.ISortedPropertyDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.PropertySheetEntry;

public class ExtendedSortedPropertySheetPage
extends ExtendedPropertySheetPage {
    public ExtendedSortedPropertySheetPage(AdapterFactoryEditingDomain editingDomain, ExtendedPropertySheetPage.Decoration decoration, IDialogSettings dialogSettings) {
        super(editingDomain, decoration, dialogSettings);
        this.setSorter();
    }

    public ExtendedSortedPropertySheetPage(AdapterFactoryEditingDomain editingDomain, ExtendedPropertySheetPage.Decoration decoration) {
        super(editingDomain, decoration);
        this.setSorter();
    }

    public ExtendedSortedPropertySheetPage(AdapterFactoryEditingDomain editingDomain) {
        super(editingDomain);
        this.setSorter();
    }

    private void setSorter() {
        this.setSorter(new ExtendedPropertiesSheetSorter());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        if (this.diagnosticDecorator != null) {
            class DecoratingPropertySheetEntry
            extends PropertySheetEntry
            implements ISortedPropertyDescriptor {
                DecoratingPropertySheetEntry() {
                }

                protected PropertySheetEntry createChildEntry() {
                    return new DecoratingPropertySheetEntry();
                }

                @Override
                public int getSortKey() {
                    if (this.getDescriptor() instanceof ISortedPropertyDescriptor) {
                        return ((ISortedPropertyDescriptor)this.getDescriptor()).getSortKey();
                    }
                    return 0;
                }

                public Image getImage() {
                    Diagnostic featureDiagnostic;
                    Image image = super.getImage();
                    if (image == null) {
                        image = ExtendedImageRegistry.INSTANCE.getImage(ItemPropertyDescriptor.GENERIC_VALUE_IMAGE);
                    }
                    return (featureDiagnostic = this.findDiagnostic()) != null ? ExtendedSortedPropertySheetPage.this.diagnosticDecorator.decorate(image, featureDiagnostic) : image;
                }

                protected Diagnostic findDiagnostic() {
                    IPropertyDescriptor descriptor = this.getDescriptor();
                    if (descriptor instanceof PropertyDescriptor) {
                        Object feature = ((PropertyDescriptor)descriptor).getFeature();
                        Map decorations = ExtendedSortedPropertySheetPage.this.diagnosticDecorator.getDecorations();
                        if (!decorations.isEmpty() && feature != null) {
                            for (Diagnostic diagnostic : decorations.values()) {
                                Diagnostic featureDiagnostic = this.find(diagnostic, feature);
                                if (featureDiagnostic == null) continue;
                                return featureDiagnostic;
                            }
                        }
                    }
                    return null;
                }

                protected Diagnostic find(Diagnostic diagnostic, Object feature) {
                    if (diagnostic.getData().contains(feature)) {
                        return diagnostic;
                    }
                    for (Diagnostic child : diagnostic.getChildren()) {
                        Diagnostic result = this.find(child, feature);
                        if (result == null) continue;
                        return result;
                    }
                    return null;
                }

                public String getDescription() {
                    String description = super.getDescription();
                    Diagnostic featureDiagnostic = this.findDiagnostic();
                    if (featureDiagnostic != null) {
                        return String.valueOf(description) + " - " + DiagnosticDecorator.strip((String)featureDiagnostic.getMessage());
                    }
                    return description;
                }
            }
            DecoratingPropertySheetEntry decoratingPropertySheetEntry = new DecoratingPropertySheetEntry();
            decoratingPropertySheetEntry.setPropertySourceProvider(this.propertySourceProvider);
            this.setRootEntry((IPropertySheetEntry)decoratingPropertySheetEntry);
        }
    }
}

