/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.lib;

import java.util.LinkedList;
import org.eclipse.scada.configuration.component.ComponentWorld;
import org.eclipse.scada.configuration.component.Configuration;

public final class Configurations {
    private Configurations() {
    }

    public static <T extends Configuration> T findDefaultConfiguration(ComponentWorld system, Class<T> clazz) {
        LinkedList<Configuration> candidates = new LinkedList<Configuration>();
        for (Configuration cfg : system.getConfigurations()) {
            if (!clazz.isAssignableFrom(cfg.getClass())) continue;
            candidates.add(cfg);
        }
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() > 1) {
            throw new IllegalStateException(String.format("Found more than one (%s) default configuration for type %s", candidates.size(), clazz.getName()));
        }
        return (T)((Configuration)clazz.cast(candidates.getFirst()));
    }
}

