/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.lib.create;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.Components;
import org.eclipse.scada.configuration.component.lib.create.AbstractCreationRequest;
import org.eclipse.scada.configuration.component.lib.create.AbstractItemCreator;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.Helper;
import org.eclipse.scada.configuration.component.lib.create.MasterListener;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.infrastructure.Device;
import org.eclipse.scada.configuration.infrastructure.Driver;
import org.eclipse.scada.configuration.infrastructure.MasterImport;
import org.eclipse.scada.configuration.item.CustomizationRequest;
import org.eclipse.scada.configuration.lib.Locator;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.world.osgi.ChangeCounterItem;
import org.eclipse.scada.configuration.world.osgi.ChangeType;
import org.eclipse.scada.configuration.world.osgi.ConstantItem;
import org.eclipse.scada.configuration.world.osgi.ErrorHandling;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.PersistentItem;
import org.eclipse.scada.configuration.world.osgi.ReferenceItem;
import org.eclipse.scada.configuration.world.osgi.SourceItem;
import org.eclipse.scada.configuration.world.osgi.TransientItem;
import org.eclipse.scada.core.Variant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponentItemCreator
extends AbstractItemCreator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractComponentItemCreator.class);
    protected final Component component;

    public AbstractComponentItemCreator(Component component) {
        this.component = component;
    }

    @Override
    public CreationRequest<ReferenceItem> createReferenceItem(Item source) {
        ReferenceItem item = OsgiFactory.eINSTANCE.createReferenceItem();
        item.setSource(source);
        return this.addItem(item);
    }

    @Override
    public CreationRequest<PersistentItem> createPersistentItem() {
        PersistentItem item = OsgiFactory.eINSTANCE.createPersistentItem();
        return this.addItem(item);
    }

    @Override
    public CreationRequest<TransientItem> createTransientItem() {
        TransientItem item = OsgiFactory.eINSTANCE.createTransientItem();
        return this.addItem(item);
    }

    @Override
    public CreationRequest<ConstantItem> createConstantItem(String value) {
        ConstantItem item = OsgiFactory.eINSTANCE.createConstantItem();
        item.setValue(value);
        return this.addItem(item);
    }

    @Override
    public CreationRequest<ChangeCounterItem> createChangeCounterItem(ChangeType changeType, ErrorHandling errorHandling, List<Variant> values) {
        ChangeCounterItem item = OsgiFactory.eINSTANCE.createChangeCounterItem();
        item.setOnError(errorHandling);
        item.setType(changeType);
        item.getValues().addAll(values);
        return this.addItem(item);
    }

    protected abstract void customizeItem(Item var1, CustomizationRequest var2);

    @Override
    public <T extends Item> CreationRequest<T> addItem(final T item) {
        List hier;
        if (this.component != null) {
            hier = Components.makeHierarchy((Component)this.component);
        } else if (item.getInformation() != null) {
            hier = item.getInformation().getHierarchy();
        } else {
            throw new IllegalStateException(String.format("Unable to add item %s since it neither has a component nor a hiearchy set.", item));
        }
        return new AbstractCreationRequest<T>(this.component, hier){

            @Override
            public T create() {
                return AbstractComponentItemCreator.this.addItem(item, this.buildRequest(item), this.getMasterListeners());
            }
        };
    }

    protected abstract <T extends Item> void itemAdded(T var1, CustomizationRequest var2, List<String> var3, Set<MasterListener<T>> var4);

    protected <T extends Item> T addItem(T item, CustomizationRequest customizationRequest, Set<MasterListener<T>> masterListeners) {
        ArrayList<String> originalLocalTags = new ArrayList<String>(customizationRequest.getLocalTags());
        this.customizeItem(item, customizationRequest);
        LinkedList hier = new LinkedList();
        hier.addAll(customizationRequest.getHierarchy());
        hier.addAll(customizationRequest.getLocalTags());
        item.setName(Names.makeHierarchy(hier));
        logger.debug("Setting item name: {}", (Object)item.getName());
        if (item.getInformation() == null) {
            item.setInformation(OsgiFactory.eINSTANCE.createItemInformation());
        }
        ECollections.setEList((EList)item.getInformation().getHierarchy(), (List)customizationRequest.getHierarchy());
        this.itemAdded(item, customizationRequest, originalLocalTags, masterListeners);
        return item;
    }

    @Override
    public <T extends Item> T addItem(T item, CustomizationRequest customizationRequest) {
        return this.addItem(item, customizationRequest, Collections.emptySet());
    }

    @Override
    public CreationRequest<SourceItem> createSelfItem(String sourceName) {
        SourceItem item = OsgiFactory.eINSTANCE.createSourceItem();
        item.setSourceName(sourceName);
        CreationRequest<SourceItem> req = this.addItem(item);
        req.addMasterListener(new MasterListener<SourceItem>(){

            @Override
            public void setMaster(SourceItem item, GeneratorContext.MasterContext master) {
                List endpoints = Locator.getSelfEndpoints((MasterServer)master.getImplementation());
                Helper.setSourceConnectionFromEndpoints(item, master.getImplementation(), endpoints);
            }
        });
        return req;
    }

    @Override
    public CreationRequest<SourceItem> createSourceItem(Driver source, String sourceName) {
        SourceItem item = OsgiFactory.eINSTANCE.createSourceItem();
        item.setSourceName(sourceName);
        return this.addItem(item);
    }

    @Override
    public <T extends Device> CreationRequest<SourceItem> createDeviceItem(T device, String sourceName) {
        SourceItem item = OsgiFactory.eINSTANCE.createSourceItem();
        item.setSourceName(sourceName);
        return this.addItem(item);
    }

    @Override
    public CreationRequest<SourceItem> createImportItem(MasterImport masterImport, String sourceName) {
        SourceItem item = OsgiFactory.eINSTANCE.createSourceItem();
        item.setSourceName(sourceName);
        return this.addItem(item);
    }
}

