/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.recipe.lib.internal;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.scada.configuration.recipe.lib.Recipe;
import org.eclipse.scada.configuration.recipe.lib.internal.RunnerContext;
import org.eclipse.scada.configuration.recipe.lib.internal.TaskRunner;

public class RecipeImpl
implements Recipe {
    private static final int MONITOR_AMOUNT = 10;
    private final List<TaskRunner> tasks;
    private final Map<String, Object> initialContent;
    private final Map<String, String> properties;

    public RecipeImpl(List<TaskRunner> tasks, Map<String, Object> initialContent, Map<String, String> properties) {
        this.tasks = tasks;
        this.initialContent = initialContent;
        this.properties = properties;
    }

    @Override
    public void execute(Map<String, Object> initialContext) {
        this.execute(initialContext, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void execute(Map<String, Object> initialContext, IProgressMonitor monitor) {
        RunnerContext ctx = new RunnerContext(this.properties);
        ctx.getMap().putAll(this.initialContent);
        ctx.getMap().putAll(initialContext);
        monitor.beginTask("Running recipe", this.tasks.size() * 10);
        try {
            for (TaskRunner task : this.tasks) {
                monitor.subTask(task.getName());
                task.run(ctx, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
        }
        finally {
            monitor.done();
        }
    }
}

