/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.recipe.lib.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.scada.configuration.recipe.Execute;
import org.eclipse.scada.configuration.recipe.Task;
import org.eclipse.scada.configuration.recipe.lib.Executable;
import org.eclipse.scada.configuration.recipe.lib.ExecutableFactory;
import org.eclipse.scada.configuration.recipe.lib.internal.RunnerContext;

public class TaskRunner {
    private static final String KEY_PROGRESS_MONITOR = "progressMonitor";
    private final Task task;
    private final ExecutableFactory factory;

    public TaskRunner(Task task, ExecutableFactory factory) {
        this.task = task;
        this.factory = factory;
    }

    public static String getTaskId(Task task) {
        return String.format("%s#%s", task.getDefinition().getName(), task.getName());
    }

    public String getId() {
        return TaskRunner.getTaskId(this.task);
    }

    public void run(RunnerContext ctx, IProgressMonitor monitor) {
        monitor.beginTask("Executing task", this.task.getExecute().size());
        for (Execute execute : this.task.getExecute()) {
            Executable runnable = this.convert(execute, ctx);
            SubProgressMonitor sm = new SubProgressMonitor(monitor, 1);
            ctx.getMap().put(KEY_PROGRESS_MONITOR, sm);
            runnable.run(ctx);
            ctx.getMap().remove(KEY_PROGRESS_MONITOR);
            sm.done();
        }
        monitor.done();
    }

    private Executable convert(Execute execute, RunnerContext ctx) {
        return this.factory.create(execute, ctx);
    }

    public String getName() {
        return this.task.getName();
    }
}

