/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.lib;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.CommonDriver;
import org.eclipse.scada.configuration.infrastructure.InfrastructurePackage;
import org.eclipse.scada.configuration.infrastructure.Node;
import org.eclipse.scada.configuration.infrastructure.World;
import org.eclipse.scada.configuration.infrastructure.lib.DriverFactory;
import org.eclipse.scada.configuration.infrastructure.lib.DriverValidator;
import org.eclipse.scada.configuration.infrastructure.lib.Worlds;
import org.eclipse.scada.configuration.lib.Endpoints;
import org.eclipse.scada.configuration.world.Driver;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.PasswordCredentials;
import org.eclipse.scada.configuration.world.ServiceBinding;
import org.eclipse.scada.utils.ecore.validation.Severity;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;

public abstract class AbstractCommonDriverFactory<T extends org.eclipse.scada.configuration.world.CommonDriver>
implements DriverFactory {
    private final List<DriverValidator<CommonDriver>> validators = new LinkedList<DriverValidator<CommonDriver>>();

    protected abstract void configureDriver(World var1, AbstractFactoryDriver var2, T var3);

    protected abstract T createDriver();

    public AbstractCommonDriverFactory() {
        this.validators.add(new DriverValidator<CommonDriver>(){

            @Override
            public void validate(ValidationContext ctx, CommonDriver driver) {
                if (Worlds.findCommonDriverPassword(driver) == null) {
                    ctx.add(Severity.WARNING, new Object[]{driver}, "Access to the driver is not secured by a password.", new Object[0]);
                }
                if (driver.getPortNumber() <= 0) {
                    ctx.add((EStructuralFeature)InfrastructurePackage.Literals.COMMON_DRIVER__PORT_NUMBER, "The port number ({0}) is invalid. It must be greater then zero.", new Object[]{driver.getPortNumber()});
                }
            }
        });
    }

    protected void addValidator(DriverValidator<CommonDriver> validator) {
        this.validators.add(validator);
    }

    @Override
    public Driver createDriver(World world, AbstractFactoryDriver infraDriver, Map<Node, org.eclipse.scada.configuration.world.Node> nodes) {
        T driver = this.createDriver();
        driver.setPassword((PasswordCredentials)EcoreUtil.copy((EObject)Worlds.findCommonDriverPassword((CommonDriver)infraDriver)));
        Endpoint ep = Endpoints.registerEndpoint((org.eclipse.scada.configuration.world.Node)nodes.get(infraDriver.getNode()), (int)((CommonDriver)infraDriver).getPortNumber(), (ServiceBinding)Endpoints.reference(driver), (String)("CommonDriver Endpoint: " + driver.getName()));
        driver.getEndpoints().add((Object)ep);
        this.configureDriver(world, infraDriver, driver);
        return driver;
    }

    @Override
    public void validate(ValidationContext ctx, AbstractFactoryDriver driver) {
        if (!(driver instanceof CommonDriver)) {
            ctx.add("Driver factory of type {0} can only process driver of type {1}", new Object[]{this.getClass().getSimpleName(), CommonDriver.class.getSimpleName()});
            return;
        }
        this.validateDriver(ctx, (CommonDriver)driver);
    }

    protected void validateDriver(ValidationContext ctx, CommonDriver driver) {
        for (DriverValidator<CommonDriver> validator : this.validators) {
            validator.validate(ctx, driver);
        }
    }
}

