/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.lib;

import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.infrastructure.Driver;
import org.eclipse.scada.configuration.infrastructure.EquinoxBase;
import org.eclipse.scada.configuration.infrastructure.Node;
import org.eclipse.scada.configuration.infrastructure.World;
import org.eclipse.scada.configuration.infrastructure.lib.DriverHandler;
import org.eclipse.scada.configuration.infrastructure.lib.WorldGenerator;
import org.eclipse.scada.configuration.infrastructure.lib.Worlds;
import org.eclipse.scada.configuration.lib.Endpoints;
import org.eclipse.scada.configuration.utils.Containers;
import org.eclipse.scada.configuration.world.ServiceBinding;
import org.eclipse.scada.configuration.world.osgi.ConfigurationAdministratorExporter;
import org.eclipse.scada.configuration.world.osgi.DataAccessExporter;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;

public abstract class AbstractEquinoxDriverHandler<T extends Driver & EquinoxBase, S extends org.eclipse.scada.configuration.world.Driver & EquinoxApplication>
implements DriverHandler {
    protected abstract S createDriver(T var1, Map<Node, org.eclipse.scada.configuration.world.Node> var2);

    @Override
    public org.eclipse.scada.configuration.world.Driver process(Driver infraDriver, Map<Node, org.eclipse.scada.configuration.world.Node> nodes) {
        Driver driver = infraDriver;
        S result = this.createDriver(driver, nodes);
        result.setName(driver.getName());
        ((EquinoxApplication)result).setSecurityConfiguration(Worlds.findSecurityConfiguration((EquinoxBase)driver));
        Worlds.addUserService(result, (EquinoxBase)driver);
        World world = (World)Containers.findContainer((EObject)infraDriver, World.class);
        DataAccessExporter exporter = OsgiFactory.eINSTANCE.createDataAccessExporter();
        exporter.setName("exporter");
        ((EquinoxApplication)result).getExporter().add((Object)exporter);
        exporter.getEndpoints().add((Object)Endpoints.registerEndpoint((org.eclipse.scada.configuration.world.Node)nodes.get(driver.getNode()), (int)(world.getOptions().getBaseDaNgpPort() + ((EquinoxBase)driver).getInstanceNumber()), (ServiceBinding)Endpoints.reference((EObject)exporter), (String)("EquinoxDriver Endpoint: " + driver.getName())));
        ConfigurationAdministratorExporter caExporter = OsgiFactory.eINSTANCE.createConfigurationAdministratorExporter();
        caExporter.setName("caExporter");
        ((EquinoxApplication)result).getExporter().add((Object)caExporter);
        caExporter.getEndpoints().add((Object)Endpoints.registerEndpoint((org.eclipse.scada.configuration.world.Node)nodes.get(driver.getNode()), (int)(world.getOptions().getBaseCaNgpPort() + ((EquinoxBase)driver).getInstanceNumber()), (ServiceBinding)Endpoints.reference((EObject)caExporter), (String)("CA Exporter: " + driver.getName())));
        ((EquinoxApplication)result).getModules().addAll(WorldGenerator.makeModules(world, (EquinoxBase)driver, result));
        return result;
    }
}

