/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.lib;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.scada.configuration.infrastructure.lib.DriverFactory;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends Plugin {
    private static final Logger logger = LoggerFactory.getLogger(Activator.class);
    public static final String PLUGIN_ID = "org.eclipse.scada.configuration.infrastructure.lib";
    private static final String EXTP_DRIVER = "org.eclipse.scada.configuration.infrastructure.lib.driver";
    private static final Object ELE_DRIVER_FACTORY = "driverFactory";
    private static Activator plugin;
    private static Map<String, DriverFactory> cache;
    private IRegistryEventListener listener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.listener = new IRegistryEventListener(){

            public void removed(IExtensionPoint[] extensionPoints) {
                Activator.this.clearCache();
            }

            public void removed(IExtension[] extensions) {
                Activator.this.clearCache();
            }

            public void added(IExtensionPoint[] extensionPoints) {
                Activator.this.clearCache();
            }

            public void added(IExtension[] extensions) {
                Activator.this.clearCache();
            }
        };
        Platform.getExtensionRegistry().addListener(this.listener, EXTP_DRIVER);
    }

    protected void clearCache() {
        cache = null;
    }

    public void stop(BundleContext context) throws Exception {
        Platform.getExtensionRegistry().removeListener(this.listener);
        plugin = null;
        this.clearCache();
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static DriverFactory findDriverFactory(String typeId) {
        if (plugin == null) {
            return null;
        }
        Map<String, DriverFactory> cache = Activator.getFactories();
        return cache.get(typeId);
    }

    private static Map<String, DriverFactory> getFactories() {
        Map<String, DriverFactory> cache = Activator.cache;
        if (cache == null) {
            Activator.cache = cache = Activator.createFactories();
        }
        return cache;
    }

    protected static Map<String, DriverFactory> createFactories() {
        HashMap<String, DriverFactory> result = new HashMap<String, DriverFactory>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTP_DRIVER);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            if (ELE_DRIVER_FACTORY.equals(ele.getName())) {
                String typeId = ele.getAttribute("typeId");
                logger.debug("Found driver factory for type: {}", (Object)typeId);
                try {
                    DriverFactory factory = (DriverFactory)ele.createExecutableExtension("factoryClass");
                    if (typeId != null && factory != null) {
                        result.put(typeId, factory);
                    }
                }
                catch (CoreException e) {
                    Activator.getDefault().getLog().log(e.getStatus());
                }
            }
            ++n2;
        }
        return result;
    }

    public static Set<String> getAllDriverFactories() {
        return Collections.unmodifiableSet(Activator.getFactories().keySet());
    }
}

