/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.lib;

import java.util.HashSet;
import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.Device;
import org.eclipse.scada.configuration.infrastructure.lib.DriverValidator;
import org.eclipse.scada.utils.ecore.validation.Severity;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;

public class DeviceTypeValidator<T extends AbstractFactoryDriver>
implements DriverValidator<T> {
    private final Class<?> deviceClass;

    public DeviceTypeValidator(Class<?> deviceClass) {
        this.deviceClass = deviceClass;
    }

    @Override
    public void validate(ValidationContext ctx, T driver) {
        HashSet<Device> locations = new HashSet<Device>();
        HashSet<String> illegalDevices = new HashSet<String>();
        for (Device device : driver.getDevices()) {
            if (this.deviceClass.isAssignableFrom(device.getClass())) continue;
            illegalDevices.add(device.getClass().getName());
            locations.add(device);
        }
        if (!illegalDevices.isEmpty()) {
            ctx.add(Severity.ERROR, locations.toArray(), "The driver may only contain device of type {0}. The following device types are invalid: {1}", new Object[]{this.deviceClass.getName(), illegalDevices});
        }
    }
}

