/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.generator.Profiles;
import org.eclipse.scada.configuration.globalization.EventPoolImport;
import org.eclipse.scada.configuration.globalization.Global;
import org.eclipse.scada.configuration.globalization.Globalization;
import org.eclipse.scada.configuration.globalization.GlobalizeFactory;
import org.eclipse.scada.configuration.globalization.Local;
import org.eclipse.scada.configuration.globalization.MonitorPoolImport;
import org.eclipse.scada.configuration.infrastructure.AbstractFactoryDriver;
import org.eclipse.scada.configuration.infrastructure.ApplicationConfiguration;
import org.eclipse.scada.configuration.infrastructure.Driver;
import org.eclipse.scada.configuration.infrastructure.EquinoxApplication;
import org.eclipse.scada.configuration.infrastructure.EquinoxBase;
import org.eclipse.scada.configuration.infrastructure.ExternalDriver;
import org.eclipse.scada.configuration.infrastructure.ExternalDriverPlaceholder;
import org.eclipse.scada.configuration.infrastructure.ExternalNode;
import org.eclipse.scada.configuration.infrastructure.InfrastructureFactory;
import org.eclipse.scada.configuration.infrastructure.MasterImport;
import org.eclipse.scada.configuration.infrastructure.MasterServer;
import org.eclipse.scada.configuration.infrastructure.Module;
import org.eclipse.scada.configuration.infrastructure.Node;
import org.eclipse.scada.configuration.infrastructure.Options;
import org.eclipse.scada.configuration.infrastructure.SystemNode;
import org.eclipse.scada.configuration.infrastructure.ValueArchiveServer;
import org.eclipse.scada.configuration.infrastructure.ValueArchiveSlave;
import org.eclipse.scada.configuration.infrastructure.World;
import org.eclipse.scada.configuration.infrastructure.lib.Activator;
import org.eclipse.scada.configuration.infrastructure.lib.DriverFactory;
import org.eclipse.scada.configuration.infrastructure.lib.DriverHandler;
import org.eclipse.scada.configuration.infrastructure.lib.ModuleHandler;
import org.eclipse.scada.configuration.infrastructure.lib.Worlds;
import org.eclipse.scada.configuration.lib.Endpoints;
import org.eclipse.scada.configuration.lib.ExclusiveGroups;
import org.eclipse.scada.configuration.recipe.lib.Output;
import org.eclipse.scada.configuration.security.Configuration;
import org.eclipse.scada.configuration.utils.ModelLoader;
import org.eclipse.scada.configuration.utils.TypeWalker;
import org.eclipse.scada.configuration.world.ApplicationNode;
import org.eclipse.scada.configuration.world.Credentials;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.PasswordCredentials;
import org.eclipse.scada.configuration.world.ServiceBinding;
import org.eclipse.scada.configuration.world.UsernamePasswordCredentials;
import org.eclipse.scada.configuration.world.WorldFactory;
import org.eclipse.scada.configuration.world.osgi.ApplicationModule;
import org.eclipse.scada.configuration.world.osgi.DataAccessConnection;
import org.eclipse.scada.configuration.world.osgi.DefaultEquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.DefaultMasterServer;
import org.eclipse.scada.configuration.world.osgi.DefaultValueArchiveServer;
import org.eclipse.scada.configuration.world.osgi.EventPool;
import org.eclipse.scada.configuration.world.osgi.Exporter;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.OsgiPackage;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;
import org.eclipse.scada.configuration.world.osgi.profile.ProfileFactory;
import org.eclipse.scada.utils.core.runtime.AdapterHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorldGenerator {
    private static final Logger logger = LoggerFactory.getLogger(WorldGenerator.class);
    @Inject
    @Named(value="infrastructureModel")
    private World infrastructure;
    @Output
    private org.eclipse.scada.configuration.world.World world;
    @Output
    private Globalization globalize;
    private Options options;
    private final Map<Driver, org.eclipse.scada.configuration.world.Driver> driverMap = new HashMap<Driver, org.eclipse.scada.configuration.world.Driver>();
    private final Map<ValueArchiveServer, org.eclipse.scada.configuration.world.osgi.ValueArchiveServer> valueArchiveMap = new HashMap<ValueArchiveServer, org.eclipse.scada.configuration.world.osgi.ValueArchiveServer>();
    private final Map<org.eclipse.scada.configuration.world.osgi.MasterServer, org.eclipse.scada.configuration.world.osgi.ValueArchiveServer> archiveMap = new HashMap<org.eclipse.scada.configuration.world.osgi.MasterServer, org.eclipse.scada.configuration.world.osgi.ValueArchiveServer>();
    private final Map<MasterServer, GeneratorContext.MasterContext> ctxMap = new HashMap<MasterServer, GeneratorContext.MasterContext>();

    public WorldGenerator() {
    }

    public WorldGenerator(World infrastructure) {
        this.infrastructure = infrastructure;
        this.options = infrastructure.getOptions();
    }

    public void setInfrastructure(World infrastructure) {
        this.infrastructure = infrastructure;
        this.options = infrastructure.getOptions();
    }

    public WorldGenerator getWorldGenerator() {
        return this;
    }

    public org.eclipse.scada.configuration.world.World getWorld() {
        return this.world;
    }

    public Globalization getGlobalize() {
        return this.globalize;
    }

    public Map<Driver, org.eclipse.scada.configuration.world.Driver> getDriverMap() {
        return this.driverMap;
    }

    public void generate(IProgressMonitor monitor) throws Exception {
        this.world = WorldFactory.eINSTANCE.createWorld();
        this.world.setOptions(WorldFactory.eINSTANCE.createOptions());
        this.world.getOptions().setMasterHandlerPriorities(this.infrastructure.getDefaultMasterHandlerPriorities());
        this.globalize = GlobalizeFactory.eINSTANCE.createGlobalization();
        this.globalize.setWorld(this.world);
        this.fillWorld();
        this.fillGlobalize();
    }

    protected void doNode(Node infraNode, org.eclipse.scada.configuration.world.Node cfgNode) {
        cfgNode.setHostName(infraNode.getHostName());
        cfgNode.setName(infraNode.getName());
        cfgNode.setShortDescription(infraNode.getShortDescription());
        this.world.getNodes().add((Object)cfgNode);
    }

    protected void fillWorld() throws Exception {
        HashMap<Node, org.eclipse.scada.configuration.world.Node> nodes = new HashMap<Node, org.eclipse.scada.configuration.world.Node>();
        for (Node anyNode : this.infrastructure.getNodes()) {
            Profile profile;
            int in;
            if (anyNode instanceof ExternalNode) {
                org.eclipse.scada.configuration.world.ExternalNode externalNode = WorldFactory.eINSTANCE.createExternalNode();
                this.doNode(anyNode, (org.eclipse.scada.configuration.world.Node)externalNode);
                nodes.put(anyNode, (org.eclipse.scada.configuration.world.Node)externalNode);
                continue;
            }
            if (!(anyNode instanceof SystemNode)) continue;
            SystemNode infraNode = (SystemNode)anyNode;
            ApplicationNode node = WorldFactory.eINSTANCE.createApplicationNode();
            this.doNode(anyNode, (org.eclipse.scada.configuration.world.Node)node);
            node.getServices().addAll(EcoreUtil.copyAll((Collection)infraNode.getServices()));
            nodes.put((Node)infraNode, (org.eclipse.scada.configuration.world.Node)node);
            node.getDeployments().addAll(EcoreUtil.copyAll((Collection)infraNode.getDeployment()));
            HashMap<MasterServer, DataAccessConnection> conMap = new HashMap<MasterServer, DataAccessConnection>();
            for (MasterServer infraMaster : infraNode.getMasters()) {
                in = infraMaster.getInstanceNumber();
                DefaultMasterServer master = OsgiFactory.eINSTANCE.createDefaultMasterServer();
                master.setName(infraMaster.getName());
                node.getApplications().add((Object)master);
                GeneratorContext.MasterContext masterContext = new GeneratorContext.MasterContext();
                masterContext.setDefinition(infraMaster);
                masterContext.setImplementation((org.eclipse.scada.configuration.world.osgi.MasterServer)master);
                this.ctxMap.put(infraMaster, masterContext);
                master.setCustomizationProfile(this.createProfile(this.infrastructure.getDefaultMasterCustomizationProfile()));
                master.setSecurityConfiguration(this.findSecurityConfiguration((EquinoxApplication)infraMaster));
                Worlds.addUserService((org.eclipse.scada.configuration.world.osgi.EquinoxApplication)master, infraMaster.getUserService(), this.options);
                master.getMonitorPools().addAll(EcoreUtil.copyAll((Collection)this.options.getMonitorPools()));
                master.getEventPools().addAll(EcoreUtil.copyAll((Collection)this.options.getEventPools()));
                this.createExporter(OsgiPackage.Literals.CONFIGURATION_ADMINISTRATOR_EXPORTER, (org.eclipse.scada.configuration.world.Node)node, (org.eclipse.scada.configuration.world.osgi.EquinoxApplication)master, this.infrastructure.getOptions().getBaseCaNgpPort() + in);
                this.createExporter(OsgiPackage.Literals.ALARMS_EVENTS_EXPORTER, (org.eclipse.scada.configuration.world.Node)node, (org.eclipse.scada.configuration.world.osgi.EquinoxApplication)master, this.infrastructure.getOptions().getBaseAeNgpPort() + in);
                Endpoint ep = this.createExporter(OsgiPackage.Literals.DATA_ACCESS_EXPORTER, (org.eclipse.scada.configuration.world.Node)node, (org.eclipse.scada.configuration.world.osgi.EquinoxApplication)master, this.infrastructure.getOptions().getBaseDaNgpPort() + in);
                DataAccessConnection selfConnection = OsgiFactory.eINSTANCE.createDataAccessConnection();
                selfConnection.setCredentials((Credentials)EcoreUtil.copy((EObject)this.findLocalCredentials((EquinoxApplication)infraMaster)));
                selfConnection.setName("self");
                selfConnection.setShortDescription("Connection to ourself");
                selfConnection.setEndpoint(ep);
                master.getConnections().add((Object)selfConnection);
                master.getModules().addAll(WorldGenerator.makeModules(this.infrastructure, (EquinoxBase)infraMaster, (org.eclipse.scada.configuration.world.osgi.EquinoxApplication)master));
                conMap.put(infraMaster, selfConnection);
            }
            for (ValueArchiveServer infraArchive : infraNode.getValueArchives()) {
                in = infraArchive.getInstanceNumber();
                DefaultValueArchiveServer archive = OsgiFactory.eINSTANCE.createDefaultValueArchiveServer();
                archive.setName(infraArchive.getName());
                node.getApplications().add((Object)archive);
                this.valueArchiveMap.put(infraArchive, (org.eclipse.scada.configuration.world.osgi.ValueArchiveServer)archive);
                archive.setCustomizationProfile(this.createProfile(this.infrastructure.getDefaultValueArchiveCustomizationProfile()));
                archive.setSecurityConfiguration(this.findSecurityConfiguration((EquinoxApplication)infraArchive));
                Worlds.addUserService((org.eclipse.scada.configuration.world.osgi.EquinoxApplication)archive, infraArchive.getUserService(), this.options);
                this.createExporter(OsgiPackage.Literals.HISTORICAL_DATA_EXPORTER, (org.eclipse.scada.configuration.world.Node)node, (org.eclipse.scada.configuration.world.osgi.EquinoxApplication)archive, this.infrastructure.getOptions().getBaseHdNgpPort() + in);
                this.createExporter(OsgiPackage.Literals.CONFIGURATION_ADMINISTRATOR_EXPORTER, (org.eclipse.scada.configuration.world.Node)node, (org.eclipse.scada.configuration.world.osgi.EquinoxApplication)archive, this.infrastructure.getOptions().getBaseCaNgpPort() + in);
                archive.getModules().addAll(WorldGenerator.makeModules(this.infrastructure, (EquinoxBase)infraArchive, (org.eclipse.scada.configuration.world.osgi.EquinoxApplication)archive));
                profile = Profiles.createOrGetCustomizationProfile((org.eclipse.scada.configuration.world.osgi.EquinoxApplication)archive);
                for (Map.Entry entry : conMap.entrySet()) {
                    if (((MasterServer)entry.getKey()).getArchiveTo() != infraArchive) continue;
                    Credentials credentials = this.findLocalCredentials((EquinoxApplication)infraArchive);
                    if (credentials instanceof PasswordCredentials) {
                        Profiles.addSystemProperty((Profile)profile, (String)"org.eclipse.scada.hd.exporter.http.server.user", (Object)"");
                        Profiles.addSystemProperty((Profile)profile, (String)"org.eclipse.scada.hd.exporter.http.server.password", (Object)((PasswordCredentials)PasswordCredentials.class.cast(credentials)).getPassword());
                    } else if (credentials instanceof UsernamePasswordCredentials) {
                        Profiles.addSystemProperty((Profile)profile, (String)"org.eclipse.scada.hd.exporter.http.server.user", (Object)((UsernamePasswordCredentials)UsernamePasswordCredentials.class.cast(credentials)).getUsername());
                        Profiles.addSystemProperty((Profile)profile, (String)"org.eclipse.scada.hd.exporter.http.server.password", (Object)((UsernamePasswordCredentials)UsernamePasswordCredentials.class.cast(credentials)).getPassword());
                    }
                    DataAccessConnection con = (DataAccessConnection)EcoreUtil.copy((EObject)((DataAccessConnection)entry.getValue()));
                    con.setShortDescription(String.format("Connection to master %s on %s", ((MasterServer)entry.getKey()).getName(), infraNode.getHostName()));
                    con.setName(String.format("%s.%s", ((MasterServer)entry.getKey()).getName(), infraNode.getHostName()));
                    archive.getConnections().add((Object)con);
                    this.archiveMap.put(this.ctxMap.get(entry.getKey()).getImplementation(), (org.eclipse.scada.configuration.world.osgi.ValueArchiveServer)archive);
                }
            }
            for (ValueArchiveSlave slave : infraNode.getValueSlaves()) {
                in = slave.getInstanceNumber();
                DefaultEquinoxApplication app = OsgiFactory.eINSTANCE.createDefaultEquinoxApplication();
                app.setName(slave.getName());
                app.setProfile((Profile)new ModelLoader(Profile.class).load(URI.createURI((String)"platform:/plugin/org.eclipse.scada.configuration.lib/model/defaultValueArchiveSlaveProfile.xml"), "org.eclipse.scada.configuration.world.osgi.profile"));
                node.getApplications().add((Object)app);
                app.setSecurityConfiguration(this.infrastructure.getDefaultSecurityConfiguration());
                Worlds.addUserService((org.eclipse.scada.configuration.world.osgi.EquinoxApplication)app, slave.getUserService(), this.options);
                this.createExporter(OsgiPackage.Literals.HISTORICAL_DATA_EXPORTER, (org.eclipse.scada.configuration.world.Node)node, (org.eclipse.scada.configuration.world.osgi.EquinoxApplication)app, this.infrastructure.getOptions().getBaseHdNgpPort() + in);
                this.createExporter(OsgiPackage.Literals.CONFIGURATION_ADMINISTRATOR_EXPORTER, (org.eclipse.scada.configuration.world.Node)node, (org.eclipse.scada.configuration.world.osgi.EquinoxApplication)app, this.infrastructure.getOptions().getBaseCaNgpPort() + in);
                profile = Profiles.createOrGetCustomizationProfile((org.eclipse.scada.configuration.world.osgi.EquinoxApplication)app);
                switch (slave.getStorageLayout()) {
                    case MULTI: {
                        Profiles.addSystemProperty((Profile)profile, (String)"org.eclipse.scada.hd.server.storage.slave.hds.basePath", (Object)("@" + slave.getStoragePath()));
                        break;
                    }
                    case SINGLE: {
                        Profiles.addSystemProperty((Profile)profile, (String)"org.eclipse.scada.hd.server.storage.slave.hds.basePath", (Object)slave.getStoragePath());
                    }
                }
                Credentials credentials = this.findLocalCredentials((EquinoxApplication)slave);
                if (credentials instanceof PasswordCredentials) {
                    Profiles.addSystemProperty((Profile)profile, (String)"org.eclipse.scada.hd.exporter.http.server.user", (Object)"");
                    Profiles.addSystemProperty((Profile)profile, (String)"org.eclipse.scada.hd.exporter.http.server.password", (Object)((PasswordCredentials)PasswordCredentials.class.cast(credentials)).getPassword());
                } else if (credentials instanceof UsernamePasswordCredentials) {
                    Profiles.addSystemProperty((Profile)profile, (String)"org.eclipse.scada.hd.exporter.http.server.user", (Object)((UsernamePasswordCredentials)UsernamePasswordCredentials.class.cast(credentials)).getUsername());
                    Profiles.addSystemProperty((Profile)profile, (String)"org.eclipse.scada.hd.exporter.http.server.password", (Object)((UsernamePasswordCredentials)UsernamePasswordCredentials.class.cast(credentials)).getPassword());
                }
                app.getModules().addAll(WorldGenerator.makeModules(this.infrastructure, (EquinoxBase)slave, (org.eclipse.scada.configuration.world.osgi.EquinoxApplication)app));
            }
        }
        for (Node anyNode : this.infrastructure.getNodes()) {
            org.eclipse.scada.configuration.world.Node basicNode = (org.eclipse.scada.configuration.world.Node)nodes.get(anyNode);
            if (!(basicNode instanceof ApplicationNode)) continue;
            SystemNode infraNode = (SystemNode)anyNode;
            ApplicationNode node = (ApplicationNode)basicNode;
            for (Driver infraDriver : infraNode.getDrivers()) {
                this.createDriver(infraDriver, nodes, node);
            }
        }
        List masters = new TypeWalker(MasterServer.class).toList((EObject)this.infrastructure);
        for (Map.Entry<Driver, org.eclipse.scada.configuration.world.Driver> entry : this.driverMap.entrySet()) {
            for (MasterServer master : masters) {
                if (!master.getDriver().contains((Object)entry.getKey())) continue;
                this.connectMasterToDriver(master, entry.getKey(), (Endpoint)entry.getValue().getEndpoints().get(0));
            }
        }
    }

    protected Configuration findSecurityConfiguration(EquinoxApplication app) {
        if (app.getSecurityConfiguration() != null) {
            return app.getSecurityConfiguration();
        }
        return this.infrastructure.getDefaultSecurityConfiguration();
    }

    public static Collection<ApplicationModule> makeModules(World world, EquinoxBase app, org.eclipse.scada.configuration.world.osgi.EquinoxApplication implApp) {
        LinkedList<ApplicationModule> result = new LinkedList<ApplicationModule>();
        result.addAll(EcoreUtil.copyAll((Collection)world.getApplicationConfigurations()));
        ExclusiveGroups.removeGroups(result, (Collection)app.getConfigurations());
        result.addAll(EcoreUtil.copyAll((Collection)app.getConfigurations()));
        ArrayList<Module> modules = new ArrayList<Module>();
        ApplicationConfiguration cfg = app.getConfiguration();
        if (cfg != null) {
            ExclusiveGroups.removeGroups(result, (Collection)cfg.getConfigurations());
            result.addAll(EcoreUtil.copyAll((Collection)cfg.getConfigurations()));
            modules.addAll((Collection<Module>)cfg.getModules());
        }
        ExclusiveGroups.removeGroups(result, (Collection)app.getModules());
        modules.addAll((Collection<Module>)app.getModules());
        WorldGenerator.processModules(app, implApp, result, modules);
        return result;
    }

    protected static void processModules(EquinoxBase app, org.eclipse.scada.configuration.world.osgi.EquinoxApplication implApp, Collection<ApplicationModule> result, Collection<Module> modules) {
        for (Module m : modules) {
            ModuleHandler mh = (ModuleHandler)AdapterHelper.adapt((Object)m, ModuleHandler.class);
            if (mh == null) {
                throw new IllegalStateException(String.format("Unknown how to process application module: %s", m.getClass().getName()));
            }
            mh.process(m, result, app, implApp);
        }
    }

    public Credentials findLocalCredentials(EquinoxApplication app) {
        logger.debug("Looking for credentials: {}", (Object)app);
        if (app.getLocalCredentials() != null) {
            logger.debug("Using local: {}", (Object)app.getLocalCredentials());
            return app.getLocalCredentials();
        }
        logger.debug("Using global: {}", (Object)this.infrastructure.getDefaultCredentials());
        return this.infrastructure.getDefaultCredentials();
    }

    private Profile createProfile(Profile profile) {
        if (profile == null) {
            return null;
        }
        Profile newProfile = ProfileFactory.eINSTANCE.createProfile();
        newProfile.getIncludes().add((Object)profile);
        newProfile.setName("Local customization profile");
        return newProfile;
    }

    private void connectMasterToDriver(MasterServer master, Driver driver, Endpoint ep) {
        DataAccessConnection connection;
        String tt = driver.getProtocolTypeTag();
        if (tt == null || tt.isEmpty()) {
            tt = "ngp";
        }
        switch (tt) {
            case "sfp": {
                connection = OsgiFactory.eINSTANCE.createSfpDataAccessConnection();
                break;
            }
            case "ngp": {
                connection = OsgiFactory.eINSTANCE.createDataAccessConnection();
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Protocol type '%s' is unsupported", tt));
            }
        }
        connection.setEndpoint(ep);
        connection.setName(Worlds.makeConnectionName(driver));
        connection.setCredentials((Credentials)EcoreUtil.copy((EObject)Worlds.findConnectionPassword(driver)));
        org.eclipse.scada.configuration.world.osgi.MasterServer mappedMaster = this.ctxMap.get(master).getImplementation();
        mappedMaster.getConnections().add((Object)connection);
    }

    private org.eclipse.scada.configuration.world.Driver createDriver(Driver driver, Map<Node, org.eclipse.scada.configuration.world.Node> nodes, ApplicationNode node) {
        DriverHandler driverHandler = (DriverHandler)AdapterHelper.adapt((Object)driver, DriverHandler.class, (boolean)true);
        if (driverHandler != null) {
            org.eclipse.scada.configuration.world.Driver result = driverHandler.process(driver, nodes);
            this.finishDriver(result, driver, node, true);
            return result;
        }
        if (driver instanceof AbstractFactoryDriver) {
            DriverFactory factory = Activator.findDriverFactory(((AbstractFactoryDriver)driver).getDriverTypeId());
            if (factory == null) {
                throw new IllegalStateException(String.format("Unable to locate driver factory for type '%s'", driver));
            }
            org.eclipse.scada.configuration.world.Driver result = factory.createDriver(this.infrastructure, (AbstractFactoryDriver)driver, nodes);
            this.finishDriver(result, driver, node, true);
            return result;
        }
        if (driver instanceof ExternalDriver) {
            ExternalDriverPlaceholder result = InfrastructureFactory.eINSTANCE.createExternalDriverPlaceholder();
            result.setName(driver.getName());
            ServiceBinding bindingService = ((ExternalDriver)driver).isBinding() ? Endpoints.contain((EObject)result) : null;
            result.getEndpoints().add((Object)Endpoints.registerEndpoint((org.eclipse.scada.configuration.world.Node)node, (int)((ExternalDriver)driver).getPortNumber(), (ServiceBinding)bindingService, (String)("ExternalDriver Endpoint: " + driver.getName())));
            this.finishDriver((org.eclipse.scada.configuration.world.Driver)result, driver, node, false);
            return result;
        }
        throw new IllegalStateException(String.format("Driver type '%s' is not supported", driver.eClass().getName()));
    }

    private void finishDriver(org.eclipse.scada.configuration.world.Driver driver, Driver infraDriver, ApplicationNode node, boolean add) {
        driver.setName(infraDriver.getName());
        if (driver.getEndpoints().isEmpty()) {
            throw new IllegalStateException(String.format("Driver has no endpoints: %s", driver));
        }
        node.getEndpoints().addAll((Collection)driver.getEndpoints());
        this.driverMap.put(infraDriver, driver);
        if (add) {
            node.getApplications().add((Object)driver);
        }
    }

    protected void fillGlobalize() {
        for (Node anyNode : this.infrastructure.getNodes()) {
            if (!(anyNode instanceof SystemNode)) continue;
            SystemNode infraNode = (SystemNode)anyNode;
            for (MasterServer infraMaster : infraNode.getMasters()) {
                if (infraMaster.getImportMaster().isEmpty()) continue;
                GeneratorContext.MasterContext master = this.ctxMap.get(infraMaster);
                Global global = GlobalizeFactory.eINSTANCE.createGlobal();
                this.globalize.getGlobals().add((Object)global);
                global.setGlobal(master.getImplementation());
                for (EventPool pool : this.options.getEventPools()) {
                    EventPoolImport eventImport = GlobalizeFactory.eINSTANCE.createEventPoolImport();
                    eventImport.setIncludeLocal(true);
                    eventImport.setLocalName(pool.getName());
                    eventImport.setPoolSize(pool.getSize());
                    eventImport.setName("proxy." + pool.getName());
                    global.getEventPoolImports().add((Object)eventImport);
                }
                for (EventPool pool : this.options.getMonitorPools()) {
                    MonitorPoolImport monitorImport = GlobalizeFactory.eINSTANCE.createMonitorPoolImport();
                    monitorImport.setIncludeLocal(true);
                    monitorImport.setLocalName(pool.getName());
                    monitorImport.setName("proxy." + pool.getName());
                    global.getMonitorPoolImports().add((Object)monitorImport);
                }
                for (MasterImport masterImport : infraMaster.getImportMaster()) {
                    Local local = GlobalizeFactory.eINSTANCE.createLocal();
                    global.getLocals().add((Object)local);
                    local.setId(masterImport.getId());
                    local.setLocal(this.ctxMap.get(masterImport.getImportedMaster()).getImplementation());
                    local.getAuthoratives().addAll(EcoreUtil.copyAll((Collection)masterImport.getImportedMaster().getAuthoratives()));
                    local.setLogonCredentials((Credentials)EcoreUtil.copy((EObject)Worlds.findConnectionCredentials(masterImport)));
                    GeneratorContext.MasterContext importedMaster = this.ctxMap.get(masterImport.getImportedMaster());
                    importedMaster.getGlobalContext().add(new GeneratorContext.GlobalContext(local, masterImport));
                }
            }
        }
    }

    private Endpoint createExporter(EClass exporterClass, org.eclipse.scada.configuration.world.Node node, org.eclipse.scada.configuration.world.osgi.EquinoxApplication application, int port) {
        Exporter exporter = (Exporter)EcoreUtil.create((EClass)exporterClass);
        Endpoint ep = Endpoints.registerEndpoint((org.eclipse.scada.configuration.world.Node)node, (int)port, (ServiceBinding)Endpoints.reference((EObject)exporter), (String)String.format("Exporter Endpoint: %s - %s", exporter.getTypeTag(), exporter.getName()));
        node.getEndpoints().add((Object)ep);
        exporter.setName(String.valueOf(application.getName()) + "/exporter");
        exporter.getEndpoints().add((Object)ep);
        application.getExporter().add((Object)exporter);
        return ep;
    }

    public Map<org.eclipse.scada.configuration.world.osgi.MasterServer, org.eclipse.scada.configuration.world.osgi.ValueArchiveServer> getArchiveMap() {
        return this.archiveMap;
    }

    public GeneratorContext.MasterContext getMasterContext(MasterServer master) {
        return this.ctxMap.get(master);
    }
}

