/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.lib.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.scada.configuration.generator.Profiles;
import org.eclipse.scada.configuration.infrastructure.ConfigurationAdminFileBackend;
import org.eclipse.scada.configuration.infrastructure.EquinoxBase;
import org.eclipse.scada.configuration.infrastructure.Module;
import org.eclipse.scada.configuration.infrastructure.lib.ModuleHandler;
import org.eclipse.scada.configuration.world.osgi.ApplicationModule;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;
import org.eclipse.scada.utils.str.StringReplacer;

public class CAFileModuleHandler
implements ModuleHandler {
    private static final Pattern VAR_PATTERN = Pattern.compile("\\#\\{([^{}]*?)\\}");

    @Override
    public void process(Module module, Collection<ApplicationModule> modules, EquinoxBase app, EquinoxApplication implApp) {
        ConfigurationAdminFileBackend s = (ConfigurationAdminFileBackend)module;
        Profile p = Profiles.createOrGetCustomizationProfile((EquinoxApplication)implApp);
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("name", app.getName());
        Profiles.addSystemProperty((Profile)p, (String)"org.eclipse.scada.ca.file.root", (Object)this.makePath(vars, s));
        p.getInstallationUnits().add((Object)"org.eclipse.scada.ca.file");
        Profiles.addStartBundle((Profile)p, (String)"org.eclipse.scada.ca.file");
    }

    private String makePath(Map<String, String> vars, ConfigurationAdminFileBackend s) {
        return StringReplacer.replace((String)s.getPath(), (StringReplacer.ReplaceSource)StringReplacer.newExtendedSource(vars), (Pattern)VAR_PATTERN, (boolean)true);
    }
}

