/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.infrastructure.lib.internal;

import java.util.Collection;
import org.eclipse.scada.configuration.generator.Profiles;
import org.eclipse.scada.configuration.infrastructure.EquinoxBase;
import org.eclipse.scada.configuration.infrastructure.JMXSettings;
import org.eclipse.scada.configuration.infrastructure.Module;
import org.eclipse.scada.configuration.infrastructure.lib.ModuleHandler;
import org.eclipse.scada.configuration.lib.Nodes;
import org.eclipse.scada.configuration.world.Application;
import org.eclipse.scada.configuration.world.Node;
import org.eclipse.scada.configuration.world.osgi.ApplicationModule;
import org.eclipse.scada.configuration.world.osgi.EquinoxApplication;
import org.eclipse.scada.configuration.world.osgi.profile.Profile;

public class JMXSettingsModuleHandler
implements ModuleHandler {
    @Override
    public void process(Module module, Collection<ApplicationModule> modules, EquinoxBase app, EquinoxApplication implApp) {
        JMXSettings s = (JMXSettings)module;
        Profile p = Profiles.createOrGetCustomizationProfile((EquinoxApplication)implApp);
        Profiles.addSystemProperty((Profile)p, (String)"com.sun.management.jmxremote", (Object)"");
        Integer port = this.makePort(s, app);
        Profiles.addSystemProperty((Profile)p, (String)"com.sun.management.jmxremote.port", (Object)port);
        Profiles.addSystemProperty((Profile)p, (String)"com.sun.management.jmxremote.local.only", (Object)s.getLocalOnly());
        Profiles.addSystemProperty((Profile)p, (String)"com.sun.management.jmxremote.authenticate", (Object)s.getAuthenticated());
        Profiles.addSystemProperty((Profile)p, (String)"com.sun.management.jmxremote.ssl", (Object)s.getSsl());
        Node node = Nodes.fromApp((Application)implApp);
        if (s.isAssignNodeHostname() && node != null && node.getHostName() != null && !node.getHostName().isEmpty()) {
            Profiles.addSystemProperty((Profile)p, (String)"java.rmi.server.hostname", (Object)node.getHostName());
        }
    }

    private Integer makePort(JMXSettings s, EquinoxBase app) {
        if (s.getPort() != null) {
            return s.getPort();
        }
        if (s.getInstancePortOffset() != null) {
            return s.getInstancePortOffset() + app.getInstanceNumber();
        }
        return null;
    }
}

