/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.tools.dialog;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ObservablesManager;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.scada.configuration.component.tools.MasterMode;
import org.eclipse.scada.configuration.infrastructure.InfrastructurePackage;
import org.eclipse.scada.configuration.infrastructure.MasterServer;
import org.eclipse.scada.configuration.infrastructure.SystemNode;
import org.eclipse.scada.configuration.infrastructure.World;
import org.eclipse.scada.configuration.infrastructure.provider.InfrastructureItemProviderAdapterFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MasterSelectionDialog
extends TitleAreaDialog {
    private final World world;
    private final WritableValue masterValue = new WritableValue();
    private Button replace;
    private MasterMode mode;
    private Button delete;

    public MasterSelectionDialog(Shell parentShell, World world) {
        super(parentShell);
        this.world = world;
        this.setHelpAvailable(false);
    }

    public MasterServer getMaster() {
        Object value = this.masterValue.getValue();
        if (value instanceof MasterServer) {
            return (MasterServer)value;
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Select master server");
        this.setMessage("Choose a master server from the world model");
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite wrapper = new Composite(composite, 0);
        wrapper.setLayout((Layout)new GridLayout(1, true));
        wrapper.setLayoutData((Object)new GridData(4, 4, true, true));
        ObservablesManager mgr = new ObservablesManager();
        final TreeViewer viewer = new TreeViewer(wrapper);
        viewer.setAutoExpandLevel(2);
        viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MasterSelectionDialog.this.handleDoubleClick();
            }
        });
        Button add = new Button(wrapper, 16);
        add.setText("Add master server");
        add.setToolTipText("Assign the component to the selected master server in addition");
        this.replace = new Button(wrapper, 16);
        this.replace.setText("Replace all master servers");
        this.replace.setToolTipText("Assign the component soley to the selected master server");
        this.replace.setSelection(true);
        this.delete = new Button(wrapper, 16);
        this.delete.setText("Remove master server");
        this.delete.setToolTipText("Un-assign the component from the selected master server");
        mgr.runAndCollect(new Runnable(){

            @Override
            public void run() {
                MasterSelectionDialog.this.createDataModel(viewer);
            }
        });
        return composite;
    }

    public MasterMode getMode() {
        return this.mode;
    }

    protected void handleDoubleClick() {
        if (this.getMaster() != null) {
            this.updateMode();
            this.setReturnCode(0);
            this.close();
        }
    }

    protected void okPressed() {
        this.updateMode();
        super.okPressed();
    }

    protected void updateMode() {
        this.mode = this.replace.getSelection() ? MasterMode.REPLACE : (this.delete.getSelection() ? MasterMode.DELETE : MasterMode.ADD);
    }

    protected void createDataModel(TreeViewer viewer) {
        final DataBindingContext dbc = new DataBindingContext();
        IObservableFactory listFactory = new IObservableFactory(){

            public IObservable createObservable(Object target) {
                if (target instanceof IObservableList) {
                    return (IObservableList)target;
                }
                if (target instanceof World) {
                    return EMFObservables.observeList((EObject)((EObject)target), (EStructuralFeature)InfrastructurePackage.Literals.WORLD__NODES);
                }
                if (target instanceof SystemNode) {
                    return EMFObservables.observeList((EObject)((EObject)target), (EStructuralFeature)InfrastructurePackage.Literals.SYSTEM_NODE__MASTERS);
                }
                return null;
            }
        };
        InfrastructureItemProviderAdapterFactory adapterFactory = new InfrastructureItemProviderAdapterFactory();
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        ObservableListTreeContentProvider cp = new ObservableListTreeContentProvider(listFactory, null);
        viewer.setContentProvider((IContentProvider)cp);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        viewer.setInput((Object)EMFObservables.observeList((EObject)this.world, (EStructuralFeature)InfrastructurePackage.Literals.WORLD__NODES));
        viewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return element instanceof SystemNode || element instanceof MasterServer;
            }
        }});
        dbc.bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)viewer), (IObservableValue)this.masterValue);
        this.masterValue.addValueChangeListener(new IValueChangeListener(){

            public void handleValueChange(ValueChangeEvent event) {
                MasterSelectionDialog.this.update();
            }
        });
        viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dbc.dispose();
            }
        });
    }

    protected Control createContents(Composite parent) {
        Control result = super.createContents(parent);
        this.update();
        return result;
    }

    private void update() {
        Button button = this.getButton(0);
        if (button == null) {
            return;
        }
        button.setEnabled(this.getMaster() != null);
    }
}

