/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.tools.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.scada.configuration.component.ComponentPackage;
import org.eclipse.scada.configuration.component.ExternalValue;
import org.eclipse.scada.configuration.component.tools.dialog.DriverSelectionDialog;
import org.eclipse.scada.configuration.component.tools.handler.AbstractToolHandler;
import org.eclipse.scada.configuration.component.tools.utils.CompoundManager;
import org.eclipse.scada.configuration.infrastructure.Driver;
import org.eclipse.scada.configuration.infrastructure.World;
import org.eclipse.scada.ui.utils.SelectionHelper;

public class SetConnectionHandler
extends AbstractToolHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Driver driver;
        try {
            driver = this.selectDriver();
        }
        catch (CoreException e) {
            throw new ExecutionException("Failed to select driver", (Throwable)e);
        }
        if (driver != null) {
            this.setConnection(driver);
        }
        return null;
    }

    private Driver selectDriver() throws CoreException {
        World world = this.findInfrastructureWorld();
        if (world == null) {
            return null;
        }
        DriverSelectionDialog dlg = new DriverSelectionDialog(this.getShell(), world);
        if (dlg.open() == 0) {
            return dlg.getDriver();
        }
        return null;
    }

    public void setConnection(Driver driver) {
        CompoundManager manager = new CompoundManager();
        for (ExternalValue v : SelectionHelper.iterable((ISelection)this.getSelection(), ExternalValue.class)) {
            EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)v);
            if (domain == null) continue;
            manager.append(domain, SetCommand.create((EditingDomain)domain, (Object)v, (Object)ComponentPackage.Literals.EXTERNAL_VALUE__CONNECTION, (Object)driver));
        }
        manager.executeAll();
    }
}

