/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.tools.handler;

import java.util.Collections;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.scada.configuration.component.ComponentPackage;
import org.eclipse.scada.configuration.component.MasterAssigned;
import org.eclipse.scada.configuration.component.tools.MasterMode;
import org.eclipse.scada.configuration.component.tools.dialog.MasterSelectionDialog;
import org.eclipse.scada.configuration.component.tools.handler.AbstractToolHandler;
import org.eclipse.scada.configuration.component.tools.utils.CompoundManager;
import org.eclipse.scada.configuration.infrastructure.MasterServer;
import org.eclipse.scada.configuration.infrastructure.World;
import org.eclipse.scada.ui.utils.SelectionHelper;

public class SetMasterHandler
extends AbstractToolHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        MasterSelectionDialog dlg;
        try {
            dlg = this.selectMaster();
        }
        catch (CoreException e) {
            throw new ExecutionException("Failed to select driver", (Throwable)e);
        }
        if (dlg != null) {
            this.setMaster(dlg.getMaster(), dlg.getMode());
        }
        return null;
    }

    private MasterSelectionDialog selectMaster() throws CoreException {
        World world = this.findInfrastructureWorld();
        if (world == null) {
            return null;
        }
        MasterSelectionDialog dlg = new MasterSelectionDialog(this.getShell(), world);
        if (dlg.open() == 0) {
            return dlg;
        }
        return null;
    }

    public void setMaster(MasterServer master, MasterMode masterMode) {
        CompoundManager manager = new CompoundManager();
        for (MasterAssigned v : SelectionHelper.iterable((ISelection)this.getSelection(), MasterAssigned.class)) {
            EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)v);
            if (domain == null) continue;
            switch (masterMode) {
                case ADD: {
                    manager.append(domain, AddCommand.create((EditingDomain)domain, (Object)v, (Object)ComponentPackage.Literals.MASTER_ASSIGNED__MASTER_ON, (Object)master));
                    break;
                }
                case REPLACE: {
                    manager.append(domain, SetCommand.create((EditingDomain)domain, (Object)v, (Object)ComponentPackage.Literals.MASTER_ASSIGNED__MASTER_ON, Collections.singletonList(master)));
                    break;
                }
                case DELETE: {
                    manager.append(domain, RemoveCommand.create((EditingDomain)domain, (Object)v, (Object)ComponentPackage.Literals.MASTER_ASSIGNED__MASTER_ON, (Object)master));
                }
            }
        }
        manager.executeAll();
    }
}

