/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.tools.wizard;

import java.util.LinkedList;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.scada.configuration.component.ExternalValue;
import org.eclipse.scada.configuration.component.provider.ComponentItemProviderAdapterFactory;
import org.eclipse.scada.configuration.component.tools.wizard.ScriptPage;
import org.eclipse.scada.configuration.component.tools.wizard.SetExternalNameWizard;
import org.eclipse.scada.ui.utils.SelectionHelper;
import org.eclipse.scada.utils.ExceptionHelper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PreviewPage
extends WizardPage {
    private final ScriptPage scriptPage;
    private final IStructuredSelection selection;
    private TableViewer viewer;
    private AdapterFactoryLabelProvider labelProvider;

    public PreviewPage(ScriptPage scriptPage, IStructuredSelection selection) {
        super("preview");
        this.scriptPage = scriptPage;
        this.selection = selection;
    }

    public void dispose() {
        super.dispose();
        this.labelProvider.dispose();
    }

    public void createControl(Composite parent) {
        this.setTitle("Preview result");
        this.setMessage("Check the result");
        this.viewer = new TableViewer(parent, 67584);
        this.viewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl(this.viewer.getControl());
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        ComponentItemProviderAdapterFactory adapterFactory = new ComponentItemProviderAdapterFactory();
        this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory);
        TableLayout layout = new TableLayout();
        this.viewer.getTable().setLayout((Layout)layout);
        TableViewerColumn col = new TableViewerColumn(this.viewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        col.getColumn().setText("Item");
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(PreviewPage.this.labelProvider.getText((Object)((Entry)cell.getElement()).getItem()));
                cell.setImage(PreviewPage.this.labelProvider.getImage((Object)((Entry)cell.getElement()).getItem()));
            }
        });
        col = new TableViewerColumn(this.viewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        col.getColumn().setText("Old name");
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                cell.setText(((Entry)cell.getElement()).getItem().getSourceName());
            }
        });
        col = new TableViewerColumn(this.viewer, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        col.getColumn().setText("Result");
        col.setLabelProvider(new CellLabelProvider(){

            public void update(ViewerCell cell) {
                PreviewPage.this.renderResult(cell, (Entry)cell.getElement());
            }
        });
    }

    protected void renderResult(ViewerCell cell, Entry element) {
        if (element.getException() != null) {
            cell.setText(ExceptionHelper.getMessage((Throwable)element.getException()));
            cell.setImage(JFaceResources.getImage((String)"dialog_message_error_image"));
        } else {
            cell.setText(element.getNewName());
            cell.setImage(null);
        }
    }

    public void refresh() {
        LinkedList<Entry> entries = new LinkedList<Entry>();
        for (ExternalValue v : SelectionHelper.iterable((ISelection)this.selection, ExternalValue.class)) {
            entries.add(this.eval(v));
        }
        this.viewer.setInput((Object)entries.toArray());
    }

    private Entry eval(ExternalValue v) {
        try {
            return new Entry(v, this.convert(v));
        }
        catch (Exception e) {
            return new Entry(v, e);
        }
    }

    private String convert(ExternalValue v) throws Exception {
        return SetExternalNameWizard.evalName(this.scriptPage.getScript(), v);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.refresh();
        }
    }

    private static class Entry {
        private final ExternalValue item;
        private final String newName;
        private final Exception exception;

        public Entry(ExternalValue item, String newName) {
            this.item = item;
            this.newName = newName;
            this.exception = null;
        }

        public Entry(ExternalValue item, Exception e) {
            this.item = item;
            this.newName = null;
            this.exception = e;
        }

        public String getNewName() {
            return this.newName;
        }

        public ExternalValue getItem() {
            return this.item;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

