/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.osgi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ChangeType implements Enumerator
{
    DELTA(0, "DELTA", "DELTA"),
    SET(1, "SET", "SET"),
    DIRECTION(2, "DIRECTION", "DIRECTION");

    public static final int DELTA_VALUE = 0;
    public static final int SET_VALUE = 1;
    public static final int DIRECTION_VALUE = 2;
    private static final ChangeType[] VALUES_ARRAY;
    public static final List<ChangeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ChangeType[]{DELTA, SET, DIRECTION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ChangeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChangeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChangeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ChangeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ChangeType get(int value) {
        switch (value) {
            case 0: {
                return DELTA;
            }
            case 1: {
                return SET;
            }
            case 2: {
                return DIRECTION;
            }
        }
        return null;
    }

    private ChangeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

