/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.osgi;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DataType implements Enumerator
{
    VARIANT(0, "VARIANT", "VARIANT"),
    NULL(1, "NULL", "NULL"),
    INT32(2, "INT32", "INT32"),
    INT64(3, "INT64", "INT64"),
    FLOAT(4, "FLOAT", "FLOAT"),
    STRING(5, "STRING", "STRING"),
    BOOLEAN(6, "BOOLEAN", "BOOLEAN");

    public static final int VARIANT_VALUE = 0;
    public static final int NULL_VALUE = 1;
    public static final int INT32_VALUE = 2;
    public static final int INT64_VALUE = 3;
    public static final int FLOAT_VALUE = 4;
    public static final int STRING_VALUE = 5;
    public static final int BOOLEAN_VALUE = 6;
    private static final DataType[] VALUES_ARRAY;
    public static final List<DataType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DataType[]{VARIANT, NULL, INT32, INT64, FLOAT, STRING, BOOLEAN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DataType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DataType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DataType get(int value) {
        switch (value) {
            case 0: {
                return VARIANT;
            }
            case 1: {
                return NULL;
            }
            case 2: {
                return INT32;
            }
            case 3: {
                return INT64;
            }
            case 4: {
                return FLOAT;
            }
            case 5: {
                return STRING;
            }
            case 6: {
                return BOOLEAN;
            }
        }
        return null;
    }

    private DataType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

