/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.world.osgi.impl;

import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.scada.configuration.utils.DerivedAttributeAdapter;
import org.eclipse.scada.configuration.world.Credentials;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.PasswordCredentials;
import org.eclipse.scada.configuration.world.UsernamePasswordCredentials;
import org.eclipse.scada.configuration.world.WorldPackage;
import org.eclipse.scada.configuration.world.osgi.Connection;
import org.eclipse.scada.configuration.world.osgi.Exporter;
import org.eclipse.scada.configuration.world.osgi.OsgiPackage;

public abstract class ConnectionImpl
extends MinimalEObjectImpl.Container
implements Connection {
    protected static final String SHORT_DESCRIPTION_EDEFAULT = null;
    protected String shortDescription = SHORT_DESCRIPTION_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected Endpoint endpoint;
    protected static final String ENDPOINT_LABEL_EDEFAULT = null;
    protected Credentials credentials;
    protected static final Integer TIMEOUT_EDEFAULT = null;
    protected Integer timeout = TIMEOUT_EDEFAULT;

    protected ConnectionImpl() {
        DerivedAttributeAdapter adapter = new DerivedAttributeAdapter((EObject)this, (EStructuralFeature)OsgiPackage.Literals.CONNECTION__ENDPOINT_LABEL);
        adapter.addNavigatedDependency((EStructuralFeature)OsgiPackage.Literals.CONNECTION__ENDPOINT, new EStructuralFeature[]{WorldPackage.Literals.ENDPOINT__PORT_NUMBER, WorldPackage.Literals.NAMED_DOCUMENTABLE__NAME});
    }

    protected EClass eStaticClass() {
        return OsgiPackage.Literals.CONNECTION;
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public void setShortDescription(String newShortDescription) {
        String oldShortDescription = this.shortDescription;
        this.shortDescription = newShortDescription;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldShortDescription, (Object)this.shortDescription));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public Endpoint getEndpoint() {
        if (this.endpoint != null && this.endpoint.eIsProxy()) {
            InternalEObject oldEndpoint = (InternalEObject)this.endpoint;
            this.endpoint = (Endpoint)this.eResolveProxy(oldEndpoint);
            if (this.endpoint != oldEndpoint && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 2, (Object)oldEndpoint, (Object)this.endpoint));
            }
        }
        return this.endpoint;
    }

    public Endpoint basicGetEndpoint() {
        return this.endpoint;
    }

    @Override
    public void setEndpoint(Endpoint newEndpoint) {
        Endpoint oldEndpoint = this.endpoint;
        this.endpoint = newEndpoint;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldEndpoint, (Object)this.endpoint));
        }
    }

    @Override
    public String getEndpointLabel() {
        Endpoint ep = this.getEndpoint();
        if (ep == null) {
            return null;
        }
        return String.format("%s - Port: %s", ep.getName(), ep.getPortNumber());
    }

    @Override
    public Credentials getCredentials() {
        if (this.credentials != null && this.credentials.eIsProxy()) {
            InternalEObject oldCredentials = (InternalEObject)this.credentials;
            this.credentials = (Credentials)this.eResolveProxy(oldCredentials);
            if (this.credentials != oldCredentials) {
                InternalEObject newCredentials = (InternalEObject)this.credentials;
                NotificationChain msgs = oldCredentials.eInverseRemove((InternalEObject)this, -5, null, null);
                if (newCredentials.eInternalContainer() == null) {
                    msgs = newCredentials.eInverseAdd((InternalEObject)this, -5, null, msgs);
                }
                if (msgs != null) {
                    msgs.dispatch();
                }
                if (this.eNotificationRequired()) {
                    this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 4, (Object)oldCredentials, (Object)this.credentials));
                }
            }
        }
        return this.credentials;
    }

    public Credentials basicGetCredentials() {
        return this.credentials;
    }

    public NotificationChain basicSetCredentials(Credentials newCredentials, NotificationChain msgs) {
        Credentials oldCredentials = this.credentials;
        this.credentials = newCredentials;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldCredentials, (Object)newCredentials);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setCredentials(Credentials newCredentials) {
        if (newCredentials != this.credentials) {
            NotificationChain msgs = null;
            if (this.credentials != null) {
                msgs = ((InternalEObject)this.credentials).eInverseRemove((InternalEObject)this, -5, null, msgs);
            }
            if (newCredentials != null) {
                msgs = ((InternalEObject)newCredentials).eInverseAdd((InternalEObject)this, -5, null, msgs);
            }
            if ((msgs = this.basicSetCredentials(newCredentials, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newCredentials, (Object)newCredentials));
        }
    }

    @Override
    public Integer getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(Integer newTimeout) {
        Integer oldTimeout = this.timeout;
        this.timeout = newTimeout;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldTimeout, (Object)this.timeout));
        }
    }

    @Override
    public String getTypeTag() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EList<Endpoint> getPossibleEndpoints(Exporter exporter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String makeUri(boolean localhost) {
        throw new UnsupportedOperationException();
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return this.basicSetCredentials(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getShortDescription();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                if (resolve) {
                    return this.getEndpoint();
                }
                return this.basicGetEndpoint();
            }
            case 3: {
                return this.getEndpointLabel();
            }
            case 4: {
                if (resolve) {
                    return this.getCredentials();
                }
                return this.basicGetCredentials();
            }
            case 5: {
                return this.getTimeout();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setShortDescription((String)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setEndpoint((Endpoint)newValue);
                return;
            }
            case 4: {
                this.setCredentials((Credentials)newValue);
                return;
            }
            case 5: {
                this.setTimeout((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setShortDescription(SHORT_DESCRIPTION_EDEFAULT);
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setEndpoint(null);
                return;
            }
            case 4: {
                this.setCredentials(null);
                return;
            }
            case 5: {
                this.setTimeout(TIMEOUT_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return SHORT_DESCRIPTION_EDEFAULT == null ? this.shortDescription != null : !SHORT_DESCRIPTION_EDEFAULT.equals(this.shortDescription);
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.endpoint != null;
            }
            case 3: {
                return ENDPOINT_LABEL_EDEFAULT == null ? this.getEndpointLabel() != null : !ENDPOINT_LABEL_EDEFAULT.equals(this.getEndpointLabel());
            }
            case 4: {
                return this.credentials != null;
            }
            case 5: {
                return TIMEOUT_EDEFAULT == null ? this.timeout != null : !TIMEOUT_EDEFAULT.equals(this.timeout);
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                return this.getTypeTag();
            }
            case 1: {
                return this.getPossibleEndpoints((Exporter)arguments.get(0));
            }
            case 2: {
                return this.makeUri((Boolean)arguments.get(0));
            }
            case 3: {
                return this.getMatchingEndpoint((Exporter)arguments.get(0));
            }
            case 4: {
                return this.getFactoryId();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public Endpoint getMatchingEndpoint(Exporter exporter) {
        EList<Endpoint> result = this.getPossibleEndpoints(exporter);
        if (result.contains((Object)this.getEndpoint())) {
            return this.getEndpoint();
        }
        return null;
    }

    @Override
    public String getFactoryId() {
        return String.valueOf(this.getTypeTag()) + ".connection";
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (shortDescription: ");
        result.append(this.shortDescription);
        result.append(", name: ");
        result.append(this.name);
        result.append(", timeout: ");
        result.append(this.timeout);
        result.append(')');
        return result.toString();
    }

    protected String makeBasicUri(boolean localhost, String type, String proto) {
        StringBuilder sb = new StringBuilder();
        sb.append(type);
        sb.append(':');
        sb.append(proto);
        sb.append("://");
        String username = null;
        String password = null;
        if (this.credentials instanceof PasswordCredentials) {
            password = ((PasswordCredentials)this.credentials).getPassword();
        } else if (this.credentials instanceof UsernamePasswordCredentials) {
            username = ((UsernamePasswordCredentials)this.credentials).getUsername();
            password = ((UsernamePasswordCredentials)this.credentials).getPassword();
        }
        boolean hasCreds = false;
        try {
            if (username != null && !username.isEmpty()) {
                hasCreds = true;
                sb.append(URLEncoder.encode(username, "UTF-8"));
            }
            if (password != null && !password.isEmpty()) {
                hasCreds = true;
                sb.append(':');
                sb.append(URLEncoder.encode(password, "UTF-8"));
            }
            if (hasCreds) {
                sb.append('@');
            }
            if (localhost) {
                sb.append("localhost");
            } else {
                sb.append(this.endpoint.getNode().getHostName());
            }
            sb.append(':');
            sb.append(this.endpoint.getPortNumber());
            HashMap<String, String> properties = new HashMap<String, String>();
            if (this.timeout != null) {
                properties.put("timeout", this.timeout.toString());
            }
            if (!properties.isEmpty()) {
                sb.append("?");
                for (Map.Entry entry : properties.entrySet()) {
                    sb.append(URLEncoder.encode((String)entry.getKey(), "UTF-8"));
                    if (entry.getValue() == null) continue;
                    sb.append('=');
                    sb.append(URLEncoder.encode((String)entry.getValue(), "UTF-8"));
                }
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }
}

