/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.globalization.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.globalization.Authorative;
import org.eclipse.scada.configuration.globalization.EventPoolImport;
import org.eclipse.scada.configuration.globalization.Exclude;
import org.eclipse.scada.configuration.globalization.Filter;
import org.eclipse.scada.configuration.globalization.Global;
import org.eclipse.scada.configuration.globalization.Globalization;
import org.eclipse.scada.configuration.globalization.Include;
import org.eclipse.scada.configuration.globalization.ItemNameFilter;
import org.eclipse.scada.configuration.globalization.Local;
import org.eclipse.scada.configuration.globalization.MonitorPoolImport;
import org.eclipse.scada.configuration.lib.DefaultFeatures;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.utils.TypeWalker;
import org.eclipse.scada.configuration.world.Credentials;
import org.eclipse.scada.configuration.world.Endpoint;
import org.eclipse.scada.configuration.world.NamedDocumentable;
import org.eclipse.scada.configuration.world.osgi.AknProxy;
import org.eclipse.scada.configuration.world.osgi.AlarmsEventsConnection;
import org.eclipse.scada.configuration.world.osgi.AlarmsEventsModule;
import org.eclipse.scada.configuration.world.osgi.ApplicationModule;
import org.eclipse.scada.configuration.world.osgi.Connection;
import org.eclipse.scada.configuration.world.osgi.DataAccessConnection;
import org.eclipse.scada.configuration.world.osgi.DataAccessExporter;
import org.eclipse.scada.configuration.world.osgi.EventPool;
import org.eclipse.scada.configuration.world.osgi.EventPoolProxy;
import org.eclipse.scada.configuration.world.osgi.Exporter;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.ItemExport;
import org.eclipse.scada.configuration.world.osgi.ItemInformation;
import org.eclipse.scada.configuration.world.osgi.MonitorPool;
import org.eclipse.scada.configuration.world.osgi.MonitorPoolProxy;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.OsgiPackage;
import org.eclipse.scada.configuration.world.osgi.PullEvents;
import org.eclipse.scada.configuration.world.osgi.SourceItem;
import org.eclipse.scada.configuration.world.osgi.SummaryItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GlobalizationProcessor {
    private static final Logger logger = LoggerFactory.getLogger(GlobalizationProcessor.class);
    @Inject
    private Globalization globalizationModel;
    private final Collection<Entry> entries = new LinkedList<Entry>();
    private int aknProxyCounter = 1;
    private final Map<Item, Integer> hierarchyLevelMap = new HashMap<Item, Integer>();

    public GlobalizationProcessor() {
    }

    public GlobalizationProcessor(Globalization globalization) {
        this.globalizationModel = globalization;
    }

    protected int countJobs() {
        int count = 0;
        for (Global global : this.globalizationModel.getGlobals()) {
            count += global.getLocals().size();
        }
        return count;
    }

    public void preProcess(IProgressMonitor monitor) {
        monitor.beginTask("Globalizing world - Phase 1/2", this.countJobs());
        try {
            for (Global global : this.globalizationModel.getGlobals()) {
                for (Local local : global.getLocals()) {
                    this.preProcessRule(global, local);
                    monitor.worked(1);
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    public void postProcess(IProgressMonitor monitor) {
        monitor.beginTask("Globalizing world - Phase 2/2", this.entries.size() + this.globalizationModel.getGlobals().size());
        try {
            this.postProcessGlobal(monitor);
            for (Entry entry : this.entries) {
                this.postProcessEntry(entry);
                monitor.worked(1);
            }
        }
        finally {
            monitor.done();
        }
    }

    private void postProcessGlobal(IProgressMonitor monitor) {
        for (Global global : this.globalizationModel.getGlobals()) {
            AlarmsEventsModule module = this.addAEModule(global);
            this.processPull(module, global);
            this.processEventPools(global, module);
            this.processMonitorPools(global, module);
            monitor.worked(1);
        }
    }

    protected void processMonitorPools(Global global, AlarmsEventsModule module) {
        for (MonitorPoolImport monitors : global.getMonitorPoolImports()) {
            MonitorPoolProxy monitorProxy = OsgiFactory.eINSTANCE.createMonitorPoolProxy();
            module.getMonitorPoolProxies().add((Object)monitorProxy);
            monitorProxy.setName(monitors.getName());
            monitorProxy.setShortDescription(monitors.getShortDescription());
            if (monitors.isIncludeLocal()) {
                for (MonitorPool localPool : global.getGlobal().getMonitorPools()) {
                    if (!localPool.getName().equals(monitors.getLocalName())) continue;
                    monitorProxy.getLocal().add((Object)localPool);
                }
            }
            for (Local local : global.getLocals()) {
                boolean found = false;
                for (MonitorPool localPool : local.getLocal().getMonitorPools()) {
                    if (!localPool.getName().equals(monitors.getLocalName())) continue;
                    monitorProxy.getRemote().add((Object)localPool);
                    found = true;
                }
                if (found) continue;
                throw new IllegalStateException(String.format("Monitor pool '%s' could not be found on instance '%s'", monitors.getLocalName(), Names.makeName((NamedDocumentable)local.getLocal())));
            }
        }
    }

    protected void processEventPools(Global global, AlarmsEventsModule module) {
        for (EventPoolImport events : global.getEventPoolImports()) {
            EventPoolProxy eventProxy = OsgiFactory.eINSTANCE.createEventPoolProxy();
            module.getEventPoolProxies().add((Object)eventProxy);
            eventProxy.setName(events.getName());
            eventProxy.setShortDescription(events.getShortDescription());
            eventProxy.setSize(events.getPoolSize());
            if (events.isIncludeLocal()) {
                eventProxy.getLocal().addAll((Collection)global.getGlobal().getEventPools());
            }
            for (Local local : global.getLocals()) {
                boolean found = false;
                for (EventPool localPool : local.getLocal().getEventPools()) {
                    if (!localPool.getName().equals(events.getLocalName())) continue;
                    eventProxy.getRemote().add((Object)localPool);
                    found = true;
                }
                if (found) continue;
                throw new IllegalStateException(String.format("Event pool '%s' could not be found on instance '%s'", events.getLocalName(), Names.makeName((NamedDocumentable)local.getLocal())));
            }
        }
    }

    protected void processPull(AlarmsEventsModule module, Global global) {
        if (global.getLocalPull() == null) {
            return;
        }
        module.getPullEvents().add((Object)((PullEvents)EcoreUtil.copy((EObject)global.getLocalPull())));
    }

    private void postProcessEntry(Entry entry) {
        this.processItems(entry.getGlobal(), entry.getLocal(), entry.getDaConnection());
        AlarmsEventsModule module = this.findAEModule(entry.getGlobal());
        for (Authorative auth : entry.getLocal().getAuthoratives()) {
            AknProxy aknProxy = OsgiFactory.eINSTANCE.createAknProxy();
            aknProxy.setConnection(entry.getAeConnection());
            aknProxy.setPriority(this.aknProxyCounter * 100);
            aknProxy.setPattern(this.makeAknProxyPattern((List<String>)auth.getHierarchy()));
            ++this.aknProxyCounter;
            module.getAknProxies().add((Object)aknProxy);
        }
    }

    private Pattern makeAknProxyPattern(List<String> hierarchy) {
        String str = Names.makeHierarchy(hierarchy);
        return Pattern.compile("^" + Pattern.quote(str) + "$");
    }

    private void preProcessRule(Global global, Local local) {
        DataAccessConnection da = this.createConnection(OsgiPackage.Literals.DATA_ACCESS_CONNECTION, DataAccessConnection.class, global, local);
        AlarmsEventsConnection ae = this.createConnection(OsgiPackage.Literals.ALARMS_EVENTS_CONNECTION, AlarmsEventsConnection.class, global, local);
        this.entries.add(new Entry(global, local, da, ae));
    }

    private AlarmsEventsModule addAEModule(Global global) {
        AlarmsEventsModule aeModule = OsgiFactory.eINSTANCE.createAlarmsEventsModule();
        Iterator i = global.getGlobal().getModules().iterator();
        while (i.hasNext()) {
            if (!(i.next() instanceof AlarmsEventsModule)) continue;
            i.remove();
        }
        global.getGlobal().getModules().add((Object)aeModule);
        return aeModule;
    }

    private AlarmsEventsModule findAEModule(Global global) {
        for (ApplicationModule current : global.getGlobal().getModules()) {
            if (!(current instanceof AlarmsEventsModule)) continue;
            return (AlarmsEventsModule)current;
        }
        throw new IllegalStateException(String.format("Unable to find %s", AlarmsEventsModule.class));
    }

    protected void processItems(Global global, Local local, DataAccessConnection da) {
        List exporters = new TypeWalker(DataAccessExporter.class).toList((EObject)global.getGlobal());
        int count = 0;
        for (Item item : local.getLocal().getItems()) {
            if (!this.isIncluded(local, item)) continue;
            SourceItem sourceItem = this.createGlobalItem(global, local, item, da);
            global.getGlobal().getItems().add((Object)sourceItem);
            ItemExport export = OsgiFactory.eINSTANCE.createItemExport();
            export.setExportName(item.getName());
            export.setItem((Item)sourceItem);
            for (DataAccessExporter exp : exporters) {
                exp.getExports().add((Object)export);
            }
            ++count;
        }
        logger.info("Globalized {} items", (Object)count);
    }

    private SourceItem createGlobalItem(Global global, Local local, Item item, DataAccessConnection da) {
        SourceItem sourceItem = OsgiFactory.eINSTANCE.createSourceItem();
        sourceItem.setInformation((ItemInformation)EcoreUtil.copy((EObject)item.getInformation()));
        sourceItem.setSourceName(item.getName());
        sourceItem.setConnection(da);
        if (item instanceof SummaryItem) {
            sourceItem.setName(this.makeGlobalSummaryName(global, local, item));
        } else {
            sourceItem.setName(item.getName());
        }
        int level = this.findAttributesHierarchyLevel(item) + 1;
        DefaultFeatures.ASUM((int)level).customize((Item)sourceItem);
        this.hierarchyLevelMap.put((Item)sourceItem, level);
        return sourceItem;
    }

    private String makeGlobalSummaryName(Global global, Local local, Item item) {
        return "SYSTEM.globalizedSummaries." + local.getId() + "." + item.getName();
    }

    private int findAttributesHierarchyLevel(Item item) {
        Integer result = this.hierarchyLevelMap.get(item);
        if (result == null) {
            return 1;
        }
        return result;
    }

    private Boolean isIncluded(Collection<Filter> filters, Item item) {
        for (Filter filter : filters) {
            Boolean result = this.check(filter, item);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private boolean isIncluded(Local local, Item item) {
        Boolean result = this.isIncluded((Collection<Filter>)local.getFilters(), item);
        if (result != null) {
            return result;
        }
        result = this.isIncluded((Collection<Filter>)local.getGlobal().getFilters(), item);
        if (result != null) {
            return result;
        }
        return local.isDefaultInclude();
    }

    private Boolean check(Filter filter, Item item) {
        if (filter instanceof Exclude) {
            if (((Exclude)filter).getPattern().matcher(item.getName()).matches()) {
                return false;
            }
        } else if (filter instanceof Include) {
            if (((Exclude)filter).getPattern().matcher(item.getName()).matches()) {
                return false;
            }
        } else if (filter instanceof ItemNameFilter) {
            String itemName = ((ItemNameFilter)filter).getItemName();
            if (itemName != null && itemName.equals(item.getName())) {
                return ((ItemNameFilter)filter).isInclude();
            }
        } else {
            throw new IllegalStateException(String.format("Filter type %s unsupported", filter.getClass()));
        }
        return null;
    }

    private <T extends Connection> T createConnection(EClass connectionClass, Class<T> clazz, Global global, Local local) {
        Connection connection = (Connection)clazz.cast(OsgiFactory.eINSTANCE.create(connectionClass));
        String tag = connection.getTypeTag();
        String cname = String.format("global.%s.to.%s.%s", Names.makeName((NamedDocumentable)global.getGlobal()), local.getId(), tag);
        connection.setName(cname);
        connection.setCredentials((Credentials)EcoreUtil.copy((EObject)this.findCredentials(global, local)));
        global.getGlobal().getConnections().add((Object)connection);
        LinkedList endpoints = new LinkedList();
        for (Exporter exporter : local.getLocal().getExporter()) {
            endpoints.addAll(connection.getPossibleEndpoints(exporter));
        }
        if (endpoints.isEmpty()) {
            throw new IllegalStateException(String.format("Unable to find an exporter that could serve as endpoint for connection type %s on master %s", connectionClass.getName(), local.getLocal().getName()));
        }
        Endpoint endpoint = (Endpoint)endpoints.getFirst();
        connection.setEndpoint(endpoint);
        return (T)connection;
    }

    private Credentials findCredentials(Global global, Local local) {
        if (local.getLogonCredentials() != null) {
            return local.getLogonCredentials();
        }
        if (global.getDefaultLogonCredentials() != null) {
            return global.getDefaultLogonCredentials();
        }
        return this.globalizationModel.getDefaultLogonCredentials();
    }

    private static class Entry {
        private final Global global;
        private final Local local;
        private final DataAccessConnection daConnection;
        private final AlarmsEventsConnection aeConnection;

        public Entry(Global global, Local local, DataAccessConnection daConnection, AlarmsEventsConnection aeConnection) {
            this.global = global;
            this.local = local;
            this.daConnection = daConnection;
            this.aeConnection = aeConnection;
        }

        public DataAccessConnection getDaConnection() {
            return this.daConnection;
        }

        public AlarmsEventsConnection getAeConnection() {
            return this.aeConnection;
        }

        public Local getLocal() {
            return this.local;
        }

        public Global getGlobal() {
            return this.global;
        }
    }
}

