/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator.text;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scada.configuration.generator.text.Message;
import org.eclipse.scada.configuration.generator.text.MessageTarget;
import org.eclipse.scada.utils.reflect.Reflections;

public class AnnotationMessageProcessor
implements MessageTarget {
    private final Object target;

    public AnnotationMessageProcessor(Object target) {
        this.target = target;
    }

    protected void processFields(FieldProcessor processor) {
        for (Field field : Reflections.findAllFields(this.target.getClass())) {
            Message message = field.getAnnotation(Message.class);
            if (message == null) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
                try {
                    processor.process(this.target, field, message);
                    continue;
                }
                finally {
                    field.setAccessible(false);
                }
            }
            processor.process(this.target, field, message);
        }
    }

    @Override
    public Map<String, String> getMessages() {
        final HashMap<String, String> result = new HashMap<String, String>();
        this.processFields(new FieldProcessor(){

            @Override
            public void process(Object target, Field field, Message message) {
                try {
                    AnnotationMessageProcessor.this.addResult(result, message.id(), field.get(target));
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        });
        return result;
    }

    private void addResult(Map<String, String> result, String name, Object value) {
        if (value instanceof String) {
            result.put(name, (String)value);
        }
    }

    public void setMessages(final Map<String, String> overrides) {
        this.processFields(new FieldProcessor(){

            @Override
            public void process(Object target, Field field, Message message) {
                try {
                    AnnotationMessageProcessor.this.setMessage(field, message.defaultText(), overrides == null ? null : (String)overrides.get(message.id()));
                }
                catch (IllegalAccessException illegalAccessException) {}
            }
        });
    }

    protected void setMessage(Field field, String defaultText, String overrideText) throws IllegalAccessException {
        if (overrideText != null) {
            field.set(this.target, overrideText);
            return;
        }
        if (defaultText != null) {
            field.set(this.target, defaultText);
            return;
        }
    }

    private static interface FieldProcessor {
        public void process(Object var1, Field var2, Message var3);
    }
}

