/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.memory;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.scada.configuration.memory.Attribute;
import org.eclipse.scada.configuration.memory.TypeDefinition;
import org.eclipse.scada.configuration.memory.TypeSystem;
import org.eclipse.scada.configuration.memory.Variable;

public final class TypeHelper {
    private TypeHelper() {
    }

    public static int calculateByteSize(int offset, TypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            return 0;
        }
        int max = 0;
        for (Variable var : typeDefinition.getVariables()) {
            if (var.getType() == null) continue;
            max = Math.max(max, offset + var.getType().getIndex() + var.getType().getLength());
            for (Attribute attr : var.getAttributes()) {
                if (attr.getType() == null) continue;
                max = Math.max(max, offset + attr.getType().getIndex() + attr.getType().getLength());
            }
        }
        return max;
    }

    public static int calculateByteSize(TypeDefinition typeDefinition) {
        return TypeHelper.calculateByteSize(0, typeDefinition);
    }

    public static boolean hasType(TypeSystem typeSystem, TypeDefinition type) {
        HashSet<TypeSystem> ctx = new HashSet<TypeSystem>();
        return TypeHelper.hasType(ctx, typeSystem, type);
    }

    private static boolean hasType(Set<TypeSystem> ctx, TypeSystem typeSystem, TypeDefinition type) {
        if (ctx.contains(typeSystem)) {
            return false;
        }
        ctx.add(typeSystem);
        if (typeSystem.getTypes().contains((Object)type)) {
            return true;
        }
        for (TypeSystem include : typeSystem.getIncludes()) {
            if (!TypeHelper.hasType(ctx, include, type)) continue;
            return true;
        }
        return false;
    }
}

