/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.da.server.ui;

import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.scada.da.server.ui.ServerDescriptor;
import org.eclipse.scada.da.server.ui.ServerHost;
import org.eclipse.scada.da.server.ui.internal.ServerHostImpl;
import org.eclipse.scada.da.server.ui.internal.ServerManagerImpl;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class HivesPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.scada.da.server.ui";
    private static HivesPlugin plugin;
    private ServerManagerImpl serverManager;
    private ServerHostImpl serverHost;

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put("error", HivesPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/error.gif"));
        reg.put("stopped", HivesPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/stopped.gif"));
        reg.put("running", HivesPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)"icons/running.gif"));
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.serverManager = new ServerManagerImpl(DisplayRealm.getRealm((Display)Display.getDefault()));
        this.serverHost = new ServerHostImpl(DisplayRealm.getRealm((Display)Display.getDefault()));
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.serverHost != null) {
            this.serverHost.dispose();
            this.serverHost = null;
        }
        if (this.serverManager != null) {
            this.serverManager.dispose();
            this.serverManager = null;
        }
        plugin = null;
        super.stop(context);
    }

    public static HivesPlugin getDefault() {
        return plugin;
    }

    public ServerManagerImpl getServerManager() {
        return this.serverManager;
    }

    public ServerHost getServerHost() {
        return this.serverHost;
    }

    public static void registerServer(ServerDescriptor descriptor) {
        HivesPlugin p = HivesPlugin.getDefault();
        if (p == null) {
            return;
        }
        p.getServerManager().register(descriptor);
    }

    public static void unregisterServer(ServerDescriptor descriptor) {
        HivesPlugin p = HivesPlugin.getDefault();
        if (p == null) {
            return;
        }
        p.getServerManager().unregister(descriptor);
    }
}

