/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.modbus.provider;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.scada.configuration.modbus.ModbusBlock;
import org.eclipse.scada.configuration.modbus.ModbusPackage;
import org.eclipse.scada.da.server.osgi.modbus.RequestType;

public class ModbusBlockItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public ModbusBlockItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addIdPropertyDescriptor(object);
            this.addNamePropertyDescriptor(object);
            this.addBlockTypePropertyDescriptor(object);
            this.addStartAddressPropertyDescriptor(object);
            this.addCountPropertyDescriptor(object);
            this.addPeriodPropertyDescriptor(object);
            this.addTimeoutPropertyDescriptor(object);
            this.addTypePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ModbusBlock_type_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ModbusBlock_type_feature", "_UI_ModbusBlock_type"), (EStructuralFeature)ModbusPackage.Literals.MODBUS_BLOCK__TYPE, true, false, true, null, null, null));
    }

    protected void addBlockTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ModbusBlock_blockType_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ModbusBlock_blockType_feature", "_UI_ModbusBlock_type"), (EStructuralFeature)ModbusPackage.Literals.MODBUS_BLOCK__BLOCK_TYPE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null){

            public Collection<?> getChoiceOfValues(Object object) {
                return Arrays.asList(RequestType.values());
            }
        });
    }

    protected void addStartAddressPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ModbusBlock_startAddress_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ModbusBlock_startAddress_feature", "_UI_ModbusBlock_type"), (EStructuralFeature)ModbusPackage.Literals.MODBUS_BLOCK__START_ADDRESS, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addCountPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ModbusBlock_count_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ModbusBlock_count_feature", "_UI_ModbusBlock_type"), (EStructuralFeature)ModbusPackage.Literals.MODBUS_BLOCK__COUNT, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addPeriodPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ModbusBlock_period_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ModbusBlock_period_feature", "_UI_ModbusBlock_type"), (EStructuralFeature)ModbusPackage.Literals.MODBUS_BLOCK__PERIOD, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addTimeoutPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ModbusBlock_timeout_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ModbusBlock_timeout_feature", "_UI_ModbusBlock_type"), (EStructuralFeature)ModbusPackage.Literals.MODBUS_BLOCK__TIMEOUT, true, false, false, ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
    }

    protected void addIdPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ModbusBlock_id_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ModbusBlock_id_feature", "_UI_ModbusBlock_type"), (EStructuralFeature)ModbusPackage.Literals.MODBUS_BLOCK__ID, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ModbusBlock_name_feature"), this.getString("_UI_ModbusBlock_name_description"), (EStructuralFeature)ModbusPackage.Literals.MODBUS_BLOCK__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/ModbusBlock"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        ModbusBlock block = (ModbusBlock)object;
        String label = block.getId();
        if (block.getName() != null && !block.getName().isEmpty()) {
            label = String.format("%s (%s)", label, block.getName());
        }
        return String.format("%s %s : %s : %s \u2192 %s (count: %s)", this.getString("_UI_ModbusBlock_type"), label == null ? "<null>" : label, block.getBlockType(), block.getStartAddress(), block.getStartAddress() + block.getCount(), block.getCount());
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ModbusBlock.class)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return ((IChildCreationExtender)this.adapterFactory).getResourceLocator();
    }
}

