/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator.component.app;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.scada.configuration.generator.FinishContext;
import org.eclipse.scada.configuration.generator.GenerationContext;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.infrastructure.MasterServer;
import org.eclipse.scada.configuration.world.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenerationContextImpl
implements GenerationContext {
    private static final Logger logger = LoggerFactory.getLogger(GenerationContextImpl.class);
    private final GeneratorContext generatorContext;
    private final Map<Object, Set<Object>> map = new HashMap<Object, Set<Object>>();

    public GenerationContextImpl(GeneratorContext generatorContext) {
        this.generatorContext = generatorContext;
    }

    public <T> T requestMapping(Object source, Class<T> targetClazz) {
        logger.debug("Requesting mapping - source: {}, target: {}", source, targetClazz);
        T result = this.findMapping(source, targetClazz);
        if (result != null) {
            return result;
        }
        logger.debug("Need to process");
        this.processFor(source);
        result = this.findMapping(source, targetClazz);
        if (result != null) {
            return result;
        }
        throw new IllegalStateException(String.format("Unable to find a mapping from %s to %s", source, targetClazz));
    }

    public FinishContext createFinishContext() {
        return new FinishContext(){

            public <T> T requestMapping(Object source, Class<T> targetClazz) {
                return GenerationContextImpl.this.requestMapping(source, targetClazz);
            }
        };
    }

    protected abstract void processFor(Object var1);

    private <T> T findMapping(Object source, Class<T> targetClazz) {
        if (source instanceof org.eclipse.scada.configuration.infrastructure.Driver && targetClazz.equals(Driver.class)) {
            return targetClazz.cast(this.generatorContext.getDriverMap().get(source));
        }
        if (source instanceof MasterServer && targetClazz.equals(org.eclipse.scada.configuration.world.osgi.MasterServer.class)) {
            return targetClazz.cast(this.generatorContext.getEquinoxApplication((MasterServer)source));
        }
        Set<Object> set = this.map.get(source);
        if (set == null) {
            return null;
        }
        for (Object o : set) {
            if (!targetClazz.isAssignableFrom(o.getClass())) continue;
            return targetClazz.cast(o);
        }
        return null;
    }

    public void addMapping(Object source, Object target) {
        logger.debug("Adding mapping - source: {}, target: {}", source, target);
        Set<Object> set = this.map.get(source);
        if (set == null) {
            set = new HashSet<Object>();
            this.map.put(source, set);
        }
        set.add(target);
    }
}

