/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator.component.app;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.infrastructure.MasterServer;
import org.eclipse.scada.configuration.infrastructure.lib.WorldGenerator;
import org.eclipse.scada.configuration.world.Driver;
import org.eclipse.scada.configuration.world.osgi.ValueArchiveServer;

public class GeneratorContextImpl
implements GeneratorContext {
    private final WorldGenerator worldGenerator;
    private final Map<Object, Map<String, Object>> attributes = new HashMap<Object, Map<String, Object>>();
    private final List<Runnable> postTriggers = new LinkedList<Runnable>();

    public GeneratorContextImpl(WorldGenerator worldGenerator) {
        this.worldGenerator = worldGenerator;
    }

    public GeneratorContext.MasterContext getMasterContext(MasterServer master) {
        return this.worldGenerator.getMasterContext(master);
    }

    public ValueArchiveServer getArchiveServer(org.eclipse.scada.configuration.world.osgi.MasterServer master) {
        return (ValueArchiveServer)this.worldGenerator.getArchiveMap().get(master);
    }

    public Map<org.eclipse.scada.configuration.infrastructure.Driver, Driver> getDriverMap() {
        return this.worldGenerator.getDriverMap();
    }

    public org.eclipse.scada.configuration.world.osgi.MasterServer getEquinoxApplication(MasterServer app) {
        return this.worldGenerator.getMasterContext(app).getImplementation();
    }

    public Collection<org.eclipse.scada.configuration.world.osgi.MasterServer> getEquinoxApplications(Collection<MasterServer> applications) {
        LinkedList<org.eclipse.scada.configuration.world.osgi.MasterServer> result = new LinkedList<org.eclipse.scada.configuration.world.osgi.MasterServer>();
        for (MasterServer app : applications) {
            result.add(this.getEquinoxApplication(app));
        }
        return result;
    }

    public Object getAttribute(Object targetObject, String key) {
        Map<String, Object> map = this.attributes.get(targetObject);
        if (map == null) {
            return null;
        }
        return map.get(key);
    }

    public void setAttribute(Object targetObject, String key, Object value) {
        Map<String, Object> map = this.attributes.get(targetObject);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.attributes.put(targetObject, map);
        }
        map.put(key, value);
    }

    public void addPostTrigger(Runnable runnable) {
        this.postTriggers.add(runnable);
    }

    public void processPostTriggers() {
        for (Runnable run : this.postTriggers) {
            run.run();
        }
    }
}

