/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator.component.app;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.scada.configuration.component.ComponentWorld;
import org.eclipse.scada.configuration.component.SummariesConfiguration;
import org.eclipse.scada.configuration.component.lib.Configurations;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.generator.component.app.MasterApplicationProcessor;
import org.eclipse.scada.configuration.infrastructure.lib.WorldGenerator;
import org.eclipse.scada.configuration.world.osgi.SummaryGroup;

public class SummariesCompressor
extends MasterApplicationProcessor {
    private SummariesConfiguration configuration;

    public SummariesCompressor() {
    }

    public SummariesCompressor(ComponentWorld system, WorldGenerator world) {
        super(system, world);
    }

    @Override
    protected void processContext(GeneratorContext.MasterContext app, IProgressMonitor monitor) {
        this.configuration = (SummariesConfiguration)Configurations.findDefaultConfiguration((ComponentWorld)this.system, SummariesConfiguration.class);
        for (SummaryGroup group : app.getImplementation().getSummaryGroups()) {
            this.processGroup(group);
        }
    }

    private void processGroup(SummaryGroup group) {
        LinkedList<SummaryGroup> removeGroups = new LinkedList<SummaryGroup>();
        int threshold = this.configuration != null && this.configuration.getItemThreshold() != null ? this.configuration.getItemThreshold() : 0;
        if (threshold <= 1) {
            return;
        }
        for (SummaryGroup subGroup : group.getSubGroups()) {
            this.processGroup(subGroup);
            if (subGroup.getItems().size() >= threshold || !subGroup.getSubGroups().isEmpty()) continue;
            group.getItems().addAll((Collection)subGroup.getItems());
            removeGroups.add(subGroup);
        }
        group.getSubGroups().removeAll(removeGroups);
    }
}

