/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.generator.component.app;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.ComponentWorld;
import org.eclipse.scada.configuration.component.Container;
import org.eclipse.scada.configuration.component.lib.create.AbstractComponentItemCreator;
import org.eclipse.scada.configuration.component.lib.create.CreationRequest;
import org.eclipse.scada.configuration.component.lib.create.MasterItemCreatorImpl;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.generator.component.app.MasterApplicationProcessor;
import org.eclipse.scada.configuration.infrastructure.lib.WorldGenerator;
import org.eclipse.scada.configuration.item.CustomizationPipeline;
import org.eclipse.scada.configuration.item.CustomizationRequest;
import org.eclipse.scada.configuration.item.CustomizationRunner;
import org.eclipse.scada.configuration.lib.Names;
import org.eclipse.scada.configuration.utils.TypeVisitor;
import org.eclipse.scada.configuration.utils.TypeWalker;
import org.eclipse.scada.configuration.world.osgi.Item;
import org.eclipse.scada.configuration.world.osgi.MasterServer;
import org.eclipse.scada.configuration.world.osgi.OsgiFactory;
import org.eclipse.scada.configuration.world.osgi.SummaryGroup;
import org.eclipse.scada.configuration.world.osgi.SummaryItem;

public class SummariesItemsGenerator
extends MasterApplicationProcessor {
    public SummariesItemsGenerator() {
    }

    public SummariesItemsGenerator(ComponentWorld system, WorldGenerator worldGenerator) {
        super(system, worldGenerator);
    }

    @Override
    public void processContext(final GeneratorContext.MasterContext app, IProgressMonitor monitor) throws Exception {
        SummariesItemCreatorImpl creator = new SummariesItemCreatorImpl(app, null, (Container)this.system);
        new TypeWalker(SummaryGroup.class).walk((EObject)app.getImplementation(), (TypeVisitor)new TypeVisitor<SummaryGroup>((AbstractComponentItemCreator)creator){
            private final /* synthetic */ AbstractComponentItemCreator val$creator;
            {
                this.val$creator = abstractComponentItemCreator;
            }

            public void visit(SummaryGroup group) throws Exception {
                SummariesItemsGenerator.this.processGroup(app.getImplementation(), group, this.val$creator);
            }
        });
    }

    protected List<CustomizationPipeline> findPipelines() {
        return Arrays.asList(this.system.getDefaultCustomizationPipeline());
    }

    protected void processGroup(MasterServer app, SummaryGroup group, AbstractComponentItemCreator creator) {
        SummaryItem item = OsgiFactory.eINSTANCE.createSummaryItem();
        item.setGroup(group);
        item.setInformation(OsgiFactory.eINSTANCE.createItemInformation());
        item.getInformation().setDescription(String.format("Summary group information: %s", Names.makeId((SummaryGroup)group)));
        item.getInformation().getHierarchy().addAll((Collection)Names.makeHierarchy((SummaryGroup)group));
        item.getInformation().setSystem("SCADA");
        CreationRequest c = creator.addItem((Item)item);
        c.localTags(new String[]{"SUMMARY"});
        c.customizationTags(new String[]{"summary"});
        SummaryItem sumItem = (SummaryItem)c.create();
        if (group.eContainer() instanceof SummaryGroup) {
            ((SummaryGroup)group.eContainer()).getItems().add((Object)sumItem);
        }
    }

    private final class SummariesItemCreatorImpl
    extends MasterItemCreatorImpl {
        private SummariesItemCreatorImpl(GeneratorContext.MasterContext master, Component component, Container container) {
            super(master, component, container);
        }

        protected void customizeItem(Item item, CustomizationRequest customizationRequest) {
            List<CustomizationPipeline> pipelines = SummariesItemsGenerator.this.findPipelines();
            new CustomizationRunner(pipelines).run(item, customizationRequest);
        }
    }
}

