/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.setup.common.validation;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.scada.configuration.setup.common.CommonPackage;
import org.eclipse.scada.configuration.setup.common.Postgres;
import org.eclipse.scada.configuration.setup.common.PostgresSetupModule;
import org.eclipse.scada.utils.ecore.validation.Severity;
import org.eclipse.scada.utils.ecore.validation.TypedValidator;
import org.eclipse.scada.utils.ecore.validation.ValidationContext;

public class PostgresSetupModuleValidator
extends TypedValidator<PostgresSetupModule> {
    public PostgresSetupModuleValidator() {
        super(PostgresSetupModule.class);
    }

    private void checkResource(ValidationContext ctx, PostgresSetupModule postgres, EStructuralFeature feature, String uriString) {
        if (uriString == null || uriString.isEmpty()) {
            return;
        }
        try {
            new Postgres(postgres).openResource(uriString).close();
        }
        catch (Exception exception) {
            Object[] arguments = new Object[]{uriString};
            ctx.add(Severity.ERROR, new Object[]{postgres, feature}, "Unable to load resource: {0}", arguments);
        }
    }

    protected void validate(PostgresSetupModule target, ValidationContext ctx) {
        this.checkResource(ctx, target, (EStructuralFeature)CommonPackage.Literals.POSTGRES_SETUP_MODULE__HOST_BASED_ACCESS_FILE, target.getHostBasedAccessFile());
        this.checkResource(ctx, target, (EStructuralFeature)CommonPackage.Literals.POSTGRES_SETUP_MODULE__CONFIGURATION_FILE, target.getConfigurationFile());
    }
}

