/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.configuration.component.generator;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.scada.configuration.component.Component;
import org.eclipse.scada.configuration.component.ComponentWorld;
import org.eclipse.scada.configuration.component.Components;
import org.eclipse.scada.configuration.component.Configuration;
import org.eclipse.scada.configuration.component.Level;
import org.eclipse.scada.configuration.component.lib.Configurations;
import org.eclipse.scada.configuration.generator.FinishContext;
import org.eclipse.scada.configuration.generator.Generator;
import org.eclipse.scada.configuration.generator.GeneratorContext;
import org.eclipse.scada.configuration.generator.PreparationContext;

public abstract class ComponentGenerator
implements Generator {
    private final Component component;
    protected GeneratorContext context;

    public ComponentGenerator(Component component) {
        this.component = component;
    }

    protected <T extends Configuration> T findConfiguration(Class<T> clazz, EClass eClazz) {
        Configuration result = Configurations.findDefaultConfiguration((ComponentWorld)this.findSystem(), clazz);
        if (result != null) {
            return (T)result;
        }
        if (eClazz == null) {
            return null;
        }
        return (T)((Configuration)clazz.cast(EcoreUtil.create((EClass)eClazz)));
    }

    protected ComponentWorld findSystem() {
        Level current = this.component.getLevel();
        while (current != null) {
            if (current instanceof ComponentWorld) {
                return (ComponentWorld)current;
            }
            current = current.eContainer();
        }
        return null;
    }

    public void initialize(GeneratorContext context) {
        this.context = context;
    }

    public void prepare(PreparationContext context) {
    }

    public void finish(FinishContext context) {
    }

    public String getFullLevelName() {
        return Components.makeFullQualified((Component)this.component, (String[])new String[0]);
    }
}

